/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph.util;

import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.math.Vector4;
import edu.cmu.cs.dennisc.scenegraph.AsSeenBy;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;
import edu.cmu.cs.dennisc.scenegraph.Scene;

public abstract class TransformationUtilities {
    private static boolean isAbsolute(ReferenceFrame sgReferenceFrame) {
        return sgReferenceFrame instanceof Scene || sgReferenceFrame == AsSeenBy.SCENE;
    }

    public static Vector4 transformToAbsolute(Vector4 rv, Vector4 xyzwInFrom, Component sgFrom) {
        rv.set(xyzwInFrom);
        TransformationUtilities.transformToAbsolute_AffectReturnValuePassedIn(rv, sgFrom);
        return rv;
    }

    public static Vector4 transformToAbsolute_New(Vector4 xyzwInFrom, Component sgFrom) {
        return TransformationUtilities.transformToAbsolute(new Vector4(), xyzwInFrom, sgFrom);
    }

    public static Vector4 transformToAbsolute_AffectReturnValuePassedIn(Vector4 rv, Component sgFrom) {
        if (!TransformationUtilities.isAbsolute(sgFrom)) {
            AffineMatrix4x4 m = sgFrom.getAbsoluteTransformation();
            m.transform(rv);
        }
        return rv;
    }

    public static Vector4 transformFromAbsolute(Vector4 rv, Vector4 xyzwInAbsolute, Component sgTo) {
        rv.set(xyzwInAbsolute);
        TransformationUtilities.transformFromAbsolute_AffectReturnValuePassedIn(rv, sgTo);
        return rv;
    }

    public static Vector4 transformFromAbsolute_New(Vector4 xyzwInAbsolute, Component sgTo) {
        return TransformationUtilities.transformFromAbsolute(new Vector4(), xyzwInAbsolute, sgTo);
    }

    public static Vector4 transformFromAbsolute_AffectReturnValuePassedIn(Vector4 rv, Component sgTo) {
        if (!TransformationUtilities.isAbsolute(sgTo)) {
            AffineMatrix4x4 m = sgTo.getInverseAbsoluteTransformation();
            m.transform(rv);
        }
        return rv;
    }

    public static Vector4 transformTo(Vector4 rv, Vector4 xyzwInFrom, Component sgFrom, Component sgTo) {
        rv.set(xyzwInFrom);
        TransformationUtilities.transformTo_AffectReturnValuePassedIn(rv, sgFrom, sgTo);
        return rv;
    }

    public static Vector4 transformTo_New(Vector4 xyzwInFrom, Component sgFrom, Component sgTo) {
        return TransformationUtilities.transformTo(new Vector4(), xyzwInFrom, sgFrom, sgTo);
    }

    public static Vector4 transformTo_AffectReturnValuePassedIn(Vector4 rv, Component sgFrom, Component sgTo) {
        TransformationUtilities.transformToAbsolute_AffectReturnValuePassedIn(rv, sgFrom);
        TransformationUtilities.transformFromAbsolute_AffectReturnValuePassedIn(rv, sgTo);
        return rv;
    }

    public static Vector3 transformToAbsolute(Vector3 rv, Vector3 xyzInFrom, Component sgFrom) {
        rv.set(xyzInFrom);
        TransformationUtilities.transformToAbsolute_AffectReturnValuePassedIn(rv, sgFrom);
        return rv;
    }

    public static Vector3 transformToAbsolute_New(Vector3 xyzInFrom, Component sgFrom) {
        return TransformationUtilities.transformToAbsolute(new Vector3(), xyzInFrom, sgFrom);
    }

    public static Vector3 transformToAbsolute_AffectReturnValuePassedIn(Vector3 rv, Component sgFrom) {
        if (!TransformationUtilities.isAbsolute(sgFrom)) {
            AffineMatrix4x4 m = sgFrom.getAbsoluteTransformation();
            m.transform(rv);
        }
        return rv;
    }

    public static Vector3 transformFromAbsolute(Vector3 rv, Vector3 xyzInAbsolute, Component sgTo) {
        rv.set(xyzInAbsolute);
        TransformationUtilities.transformFromAbsolute_AffectReturnValuePassedIn(rv, sgTo);
        return rv;
    }

    public static Vector3 transformFromAbsolute_New(Vector3 xyzInAbsolute, Component sgTo) {
        return TransformationUtilities.transformFromAbsolute(new Vector3(), xyzInAbsolute, sgTo);
    }

    public static Vector3 transformFromAbsolute_AffectReturnValuePassedIn(Vector3 rv, Component sgTo) {
        if (!TransformationUtilities.isAbsolute(sgTo)) {
            AffineMatrix4x4 m = sgTo.getInverseAbsoluteTransformation();
            m.transform(rv);
        }
        return rv;
    }

    public static Vector3 transformTo(Vector3 rv, Vector3 xyzInFrom, Component sgFrom, Component sgTo) {
        rv.set(xyzInFrom);
        TransformationUtilities.transformTo_AffectReturnValuePassedIn(rv, sgFrom, sgTo);
        return rv;
    }

    public static Vector3 transformTo_New(Vector3 xyzInFrom, Component sgFrom, Component sgTo) {
        return TransformationUtilities.transformTo(new Vector3(), xyzInFrom, sgFrom, sgTo);
    }

    public static Vector3 transformTo_AffectReturnValuePassedIn(Vector3 rv, Component sgFrom, Component sgTo) {
        TransformationUtilities.transformToAbsolute_AffectReturnValuePassedIn(rv, sgFrom);
        TransformationUtilities.transformFromAbsolute_AffectReturnValuePassedIn(rv, sgTo);
        return rv;
    }

    public static Point3 transformToAbsolute(Point3 rv, Point3 xyzInFrom, Component sgFrom) {
        rv.set(xyzInFrom);
        TransformationUtilities.transformToAbsolute_AffectReturnValuePassedIn(rv, sgFrom);
        return rv;
    }

    public static Point3 transformToAbsolute_New(Point3 xyzInFrom, Component sgFrom) {
        return TransformationUtilities.transformToAbsolute(new Point3(), xyzInFrom, sgFrom);
    }

    public static Point3 transformToAbsolute_AffectReturnValuePassedIn(Point3 rv, Component sgFrom) {
        if (!TransformationUtilities.isAbsolute(sgFrom)) {
            AffineMatrix4x4 m = sgFrom.getAbsoluteTransformation();
            m.transform(rv);
        }
        return rv;
    }

    public static Point3 transformFromAbsolute(Point3 rv, Point3 xyzInAbsolute, Component sgTo) {
        rv.set(xyzInAbsolute);
        TransformationUtilities.transformFromAbsolute_AffectReturnValuePassedIn(rv, sgTo);
        return rv;
    }

    public static Point3 transformFromAbsolute_New(Point3 xyzInAbsolute, Component sgTo) {
        return TransformationUtilities.transformFromAbsolute(new Point3(), xyzInAbsolute, sgTo);
    }

    public static Point3 transformFromAbsolute_AffectReturnValuePassedIn(Point3 rv, Component sgTo) {
        if (!TransformationUtilities.isAbsolute(sgTo)) {
            AffineMatrix4x4 m = sgTo.getInverseAbsoluteTransformation();
            m.transform(rv);
        }
        return rv;
    }

    public static Point3 transformTo(Point3 rv, Point3 xyzInFrom, Component sgFrom, Component sgTo) {
        rv.set(xyzInFrom);
        TransformationUtilities.transformTo_AffectReturnValuePassedIn(rv, sgFrom, sgTo);
        return rv;
    }

    public static Point3 transformTo_New(Point3 xyzInFrom, Component sgFrom, Component sgTo) {
        return TransformationUtilities.transformTo(new Point3(), xyzInFrom, sgFrom, sgTo);
    }

    public static Point3 transformTo_AffectReturnValuePassedIn(Point3 rv, Component sgFrom, Component sgTo) {
        TransformationUtilities.transformToAbsolute_AffectReturnValuePassedIn(rv, sgFrom);
        TransformationUtilities.transformFromAbsolute_AffectReturnValuePassedIn(rv, sgTo);
        return rv;
    }
}

