/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.stencil;

import edu.cmu.cs.dennisc.stencil.Hole;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stencil
extends JPanel {
    private List<Hole> m_holes = new LinkedList<Hole>();
    private Container m_container;

    public Stencil(Container container) {
        this.m_container = container;
        this.setOpaque(false);
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                Stencil.this.redispatch(e);
            }

            public void mouseEntered(MouseEvent e) {
                Stencil.this.redispatch(e);
            }

            public void mouseExited(MouseEvent e) {
                Stencil.this.redispatch(e);
            }

            public void mousePressed(MouseEvent e) {
                Stencil.this.redispatch(e);
            }

            public void mouseReleased(MouseEvent e) {
                Stencil.this.redispatch(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent e) {
                Stencil.this.redispatch(e);
            }

            public void mouseDragged(MouseEvent e) {
                Stencil.this.redispatch(e);
            }
        });
    }

    private void redispatch(MouseEvent e) {
        Component component;
        Point p = e.getPoint();
        if (!this.contains(p.x, p.y) && (component = SwingUtilities.getDeepestComponentAt(this.m_container, p.x, p.y)) != null) {
            Point pComponent = SwingUtilities.convertPoint(this, p, component);
            component.dispatchEvent(new MouseEvent(component, e.getID(), e.getWhen(), e.getModifiers() + e.getModifiersEx(), pComponent.x, pComponent.y, e.getClickCount(), e.isPopupTrigger()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHole(Hole hole) {
        List<Hole> list = this.m_holes;
        synchronized (list) {
            this.m_holes.add(hole);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHole(Hole hole) {
        List<Hole> list = this.m_holes;
        synchronized (list) {
            this.m_holes.remove(hole);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearHoles() {
        List<Hole> list = this.m_holes;
        synchronized (list) {
            this.m_holes.clear();
        }
    }

    public Iterable<Hole> getHoles() {
        return this.m_holes;
    }

    @Override
    public boolean contains(int x, int y) {
        Area area = this.calculateArea(this.getBounds());
        return area.contains(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Area calculateArea(Rectangle bounds) {
        Area rv = new Area(bounds);
        List<Hole> list = this.m_holes;
        synchronized (list) {
            for (Hole hole : this.m_holes) {
                rv.subtract(hole.getArea(this.m_container));
            }
        }
        return rv;
    }

    @Override
    protected void paintComponent(Graphics g) {
        assert (false);
        super.paintComponent(g);
        Area area = this.calculateArea(g.getClipBounds());
        Graphics2D g2 = (Graphics2D)g;
        g2.fill(area);
    }
}

