/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.swing;

import edu.cmu.cs.dennisc.swing.DragSource;
import edu.cmu.cs.dennisc.swing.DropTarget;
import edu.cmu.cs.dennisc.swing.event.DragEvent;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public class DragComponent
extends JComponent {
    private BufferedImage m_bufferedImage = null;
    private JLayeredPane m_layeredPane = null;
    private List<DropTarget> m_dropTargets = new LinkedList<DropTarget>();
    private DropTarget m_dropTarget = null;

    public void addDropTarget(DropTarget dropTarget) {
        this.m_dropTargets.add(dropTarget);
    }

    public void removeDropTarget(DropTarget dropTarget) {
        this.m_dropTargets.remove(dropTarget);
    }

    private void setDropTarget(DropTarget dropTarget, DragEvent e) {
        if (this.m_dropTarget != dropTarget) {
            if (this.m_dropTarget != null) {
                this.m_dropTarget.dragExited(e);
            }
            this.m_dropTarget = dropTarget;
            if (this.m_dropTarget != null) {
                this.m_dropTarget.dragEntered(e);
            }
        }
    }

    public void handleMousePressed(DragSource dragSource, MouseEvent me) {
        DragEvent e = new DragEvent(dragSource, this, me);
        for (DropTarget dropTarget : this.m_dropTargets) {
            dropTarget.dragStarted(e);
        }
        for (DropTarget dropTarget : this.m_dropTargets) {
            if (!dropTarget.isAccepting(e)) continue;
            this.setDropTarget(dropTarget, e);
        }
    }

    public void handleMouseDragged(DragSource dragSource, MouseEvent me) {
        DragEvent e = new DragEvent(dragSource, this, me);
        for (DropTarget dropTarget : this.m_dropTargets) {
            if (!dropTarget.isAccepting(e)) continue;
            this.setDropTarget(dropTarget, e);
            dropTarget.dragUpdated(e);
            break;
        }
    }

    public void handleMouseReleased(DragSource dragSource, MouseEvent me) {
        DragEvent e = new DragEvent(dragSource, this, me);
        for (DropTarget dropTarget : this.m_dropTargets) {
            if (!dropTarget.isAccepting(e)) continue;
            dropTarget.dragDropped(e);
            break;
        }
        this.setDropTarget(null, e);
        for (DropTarget dropTarget : this.m_dropTargets) {
            dropTarget.dragStopped(e);
        }
    }

    public JLayeredPane getLayeredPane() {
        return this.m_layeredPane;
    }

    public void setLayeredPane(JLayeredPane layeredPane) {
        if (this.m_layeredPane != layeredPane) {
            this.m_layeredPane = layeredPane;
        }
    }

    public BufferedImage accessBufferedImage(int width, int height) {
        if (this.m_bufferedImage == null || this.m_bufferedImage.getWidth() < width || this.m_bufferedImage.getHeight() < height) {
            this.m_bufferedImage = new BufferedImage(width, height, 2);
        }
        this.setSize(width, height);
        return this.m_bufferedImage;
    }

    protected void paintComponent(Graphics g) {
        if (this.m_bufferedImage != null) {
            g.drawImage(this.m_bufferedImage, 0, 0, this);
        }
    }

    public void removeFromLayeredPane() {
        if (this.m_layeredPane != null) {
            this.m_layeredPane.remove(this);
            this.m_layeredPane.repaint(this.getBounds());
        }
    }
}

