/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.swing;

import edu.cmu.cs.dennisc.awt.GraphicsUtilties;
import edu.cmu.cs.dennisc.swing.SwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public abstract class ExpandPane
extends AbstractButton {
    private JLabel label = this.createLabel();
    private ToggleButton toggle = new ToggleButton();
    private JComponent center;

    public ExpandPane() {
        this.setModel(new DefaultButtonModel());
        this.toggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExpandPane.this.setSelected(ExpandPane.this.toggle.isSelected());
            }
        });
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ExpandPane.this.handleToggled(e);
            }
        });
        this.label.setText(this.getCollapsedLabelText());
        this.setLayout(new BorderLayout());
        this.add((Component)this.createTopPane(), "North");
        this.center = this.createCenterPane();
    }

    public JComponent getCenterComponent() {
        return this.center;
    }

    protected JLabel createLabel() {
        return new JLabel();
    }

    protected abstract String getExpandedLabelText();

    protected abstract String getCollapsedLabelText();

    protected String getExpandedButtonText() {
        return "V";
    }

    protected String getCollapsedButtonText() {
        return ">>>";
    }

    private void handleToggled(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.add((Component)this.center, "Center");
            this.label.setText(this.getExpandedLabelText());
        } else {
            this.remove(this.center);
            this.label.setText(this.getCollapsedLabelText());
        }
        this.revalidate();
        this.repaint();
        Component root = javax.swing.SwingUtilities.getRoot(this);
        if (root instanceof Window) {
            Window window = (Window)root;
            window.pack();
        }
    }

    protected JComponent createTopPane() {
        JPanel rv = new JPanel();
        rv.setLayout(new BorderLayout());
        rv.add((Component)this.label, "Center");
        rv.add((Component)this.toggle, "East");
        return rv;
    }

    protected abstract JComponent createCenterPane();

    class ToggleButton
    extends JToggleButton {
        ToggleButton() {
        }

        public Dimension getPreferredSize() {
            Dimension rv = super.getPreferredSize();
            Font font = this.getFont();
            if (font != null) {
                Graphics g = SwingUtilities.getGraphics();
                FontMetrics fm = g.getFontMetrics(font);
                for (String s : new String[]{ExpandPane.this.getExpandedButtonText(), ExpandPane.this.getCollapsedButtonText()}) {
                    Rectangle2D bounds = fm.getStringBounds(s, g);
                    rv.width = Math.max(rv.width, (int)bounds.getWidth() + 16);
                    rv.height = Math.max(rv.height, (int)bounds.getHeight() + 4);
                }
            }
            return rv;
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            String text = this.isSelected() ? ExpandPane.this.getExpandedButtonText() : ExpandPane.this.getCollapsedButtonText();
            GraphicsUtilties.drawCenteredText(g, text, this.getSize());
        }
    }
}

