/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.swing;

import edu.cmu.cs.dennisc.swing.InputPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileSelectionPane
extends InputPane<File> {
    private JLabel feedback = new JLabel();
    private JFileChooser fileChooser = new JFileChooser();

    public FileSelectionPane() {
        this.fileChooser.setFileSelectionMode(this.getDesiredFileSelectionMode());
        this.fileChooser.setControlButtonsAreShown(false);
        this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if ("SelectedFileChangedProperty".equals(propertyName)) {
                    FileSelectionPane.this.updateOKButton();
                }
            }
        });
        this.updateOKButton();
        this.setLayout(new BorderLayout());
        this.add((Component)this.fileChooser, "Center");
        this.add((Component)this.feedback, "South");
    }

    protected JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    protected abstract String getFeedbackText();

    @Override
    public void updateOKButton() {
        super.updateOKButton();
        this.feedback.setText(this.getFeedbackText());
        Color color = this.isOKButtonValid() ? Color.BLACK : Color.RED.darker();
        this.feedback.setForeground(color);
    }

    protected int getDesiredFileSelectionMode() {
        return 0;
    }

    @Override
    protected File getActualInputValue() {
        return this.fileChooser.getSelectedFile();
    }
}

