/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.swing;

import edu.cmu.cs.dennisc.swing.List;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedList;
import javax.swing.AbstractListModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterListCombo
extends JPanel {
    private Model m_model = new Model();
    private JTextField m_filter = new JTextField();
    private List<String> m_list = new List();

    public FilterListCombo() {
        this.m_list.setModel(this.m_model);
        this.m_filter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                FilterListCombo.this.handleFilterChange(e);
            }

            public void insertUpdate(DocumentEvent e) {
                FilterListCombo.this.handleFilterChange(e);
            }

            public void removeUpdate(DocumentEvent e) {
                FilterListCombo.this.handleFilterChange(e);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_filter, "North");
        this.add((Component)new JScrollPane(this.m_list), "Center");
    }

    public JTextField getTextField() {
        return this.m_filter;
    }

    public List<String> getList() {
        return this.m_list;
    }

    public String getElementAt(int index) {
        return (String)this.m_model.getElementAt(index);
    }

    public void setData(String[] data) {
        this.m_model.setData(data);
        this.m_model.handleFilterChange(this.m_filter.getText());
    }

    private void handleFilterChange(DocumentEvent e) {
        this.m_model.handleFilterChange(this.m_filter.getText());
    }

    class Model
    extends AbstractListModel {
        private String[] m_data = new String[0];
        private java.util.List<String> m_filteredData = new LinkedList<String>();

        Model() {
        }

        public Object getElementAt(int index) {
            return this.m_filteredData.get(index);
        }

        public int getSize() {
            return this.m_filteredData.size();
        }

        public void setData(String[] data) {
            this.m_data = data;
        }

        public void handleFilterChange(String filter) {
            String filterLower = filter.toLowerCase();
            this.m_filteredData = new LinkedList<String>();
            for (String s : this.m_data) {
                String sLower = s.toLowerCase();
                if (!sLower.contains(filterLower)) continue;
                this.m_filteredData.add(s);
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }
}

