/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class List<E>
extends JList {
    private java.util.List<ActionListener> m_actionListeners = new LinkedList<ActionListener>();
    private int m_selectedIndexPrev = -1;
    private boolean m_isActionEventPrev = false;

    public List() {
        this.initialize();
    }

    public List(ListModel model) {
        super(model);
        this.initialize();
    }

    private void initialize() {
        this.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent e) {
                List.this.fireActionListeners(e.getWhen(), e.getModifiers(), true);
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int modifiers = 0;
                    List.this.fireActionListeners(System.currentTimeMillis(), modifiers, false);
                }
            }
        });
    }

    public void addActionListener(ActionListener l) {
        this.m_actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.m_actionListeners.remove(l);
    }

    private void fireActionListeners(long when, int modifiers, boolean isActionEvent) {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex != this.m_selectedIndexPrev || this.m_isActionEventPrev == isActionEvent) {
            Object value = this.getSelectedValue();
            String command = value != null ? value.toString() : null;
            ActionEvent e = new ActionEvent(this, 1001, command, when, modifiers);
            for (ActionListener l : this.m_actionListeners) {
                l.actionPerformed(e);
            }
            this.m_selectedIndexPrev = selectedIndex;
        } else {
            this.m_isActionEventPrev = isActionEvent;
        }
    }

    public E getSelectedTypedValue() {
        return this.getSelectedValue();
    }
}

