/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.BoxLayout;

public class PaddedBoxLayout
extends BoxLayout {
    private int pad;
    private int axis;

    public PaddedBoxLayout(Container target, int axis, int pad) {
        super(target, axis);
        this.axis = axis;
        this.pad = pad;
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension rv = super.preferredLayoutSize(target);
        int N = target.getComponentCount();
        switch (this.axis) {
            case 1: 
            case 3: {
                rv.height += N * this.pad;
                break;
            }
            case 0: 
            case 2: {
                rv.width += N * this.pad;
            }
        }
        return rv;
    }

    public void layoutContainer(Container target) {
        super.layoutContainer(target);
        int N = target.getComponentCount();
        for (int i = 0; i < N; ++i) {
            Component componentI = target.getComponent(i);
            Point p = componentI.getLocation();
            switch (this.axis) {
                case 1: 
                case 3: {
                    p.y += i * this.pad;
                    break;
                }
                case 0: 
                case 2: {
                    p.x += i * this.pad;
                }
            }
            componentI.setLocation(p);
        }
    }
}

