/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopupMenuUtilities {
    public static void showModal(JPopupMenu popupMenu, Component invoker, int x, int y) {
        JLayeredPane layeredPane;
        Window window;
        Component root = SwingUtilities.getRoot(invoker);
        if (root instanceof JFrame) {
            window = (JFrame)root;
            layeredPane = ((JFrame)window).getLayeredPane();
        } else if (root instanceof JDialog) {
            window = (JDialog)root;
            layeredPane = ((JDialog)window).getLayeredPane();
        } else if (root instanceof JWindow) {
            window = (JWindow)root;
            layeredPane = ((JWindow)window).getLayeredPane();
        } else {
            layeredPane = null;
        }
        if (layeredPane != null) {
            class EventConsumer
            extends JComponent {
                private MouseListener mouseAdapter = new MouseListener(){

                    public void mouseEntered(MouseEvent e) {
                    }

                    public void mouseExited(MouseEvent e) {
                    }

                    public void mousePressed(MouseEvent e) {
                    }

                    public void mouseReleased(MouseEvent e) {
                        this.removeFromParentJustInCaseAnExceptionWasThrownSomewhere();
                    }

                    public void mouseClicked(MouseEvent e) {
                    }
                };

                EventConsumer() {
                }

                private void removeFromParentJustInCaseAnExceptionWasThrownSomewhere() {
                    Container parent = this.getParent();
                    if (parent != null) {
                        parent.remove(this);
                    }
                }

                public void addNotify() {
                    super.addNotify();
                    this.setLocation(0, 0);
                    Container parent = this.getParent();
                    if (parent != null) {
                        this.setSize(parent.getSize());
                    }
                    this.addMouseListener(this.mouseAdapter);
                }

                public void removeNotify() {
                    this.removeMouseListener(this.mouseAdapter);
                    super.removeNotify();
                }
            }
            final EventConsumer eventConsumer = new EventConsumer();
            popupMenu.addPopupMenuListener(new PopupMenuListener(){
                {
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    layeredPane.add((Component)eventConsumer, new Integer(JLayeredPane.MODAL_LAYER));
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    layeredPane.remove(eventConsumer);
                }

                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
        popupMenu.show(invoker, x, y);
    }
}

