/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.swing;

import edu.cmu.cs.dennisc.croquet.LabelUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.Spring;
import javax.swing.SpringLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringUtilities {
    public static Component createColumn0Label(String text) {
        JLabel rv = LabelUtilities.createLabel(text);
        rv.setHorizontalAlignment(11);
        return rv;
    }

    public static Component[] createRow(Component ... rv) {
        for (int i = 0; i < rv.length; ++i) {
            Component box;
            if (rv[i] != null) continue;
            rv[i] = box = Box.createRigidArea(new Dimension(0, 0));
        }
        return rv;
    }

    public static Container springItUpANotch(Container rv, List<Component[]> componentRows, int xPad, int yPad) {
        assert (componentRows != null);
        int rowCount = componentRows.size();
        assert (rowCount > 0);
        int columnCount = componentRows.get(0).length;
        for (Component[] componentRow : componentRows) {
            assert (componentRow.length == columnCount);
        }
        SpringLayout layout = new SpringLayout();
        rv.setLayout(layout);
        for (Component[] componentRow : componentRows) {
            for (Component component : componentRow) {
                assert (component != null);
                rv.add(component);
            }
        }
        Spring xSpring = Spring.constant(0);
        Spring xPadSpring = Spring.constant(xPad);
        for (int c = 0; c < columnCount; ++c) {
            SpringLayout.Constraints constraints;
            Spring widthSpring = Spring.constant(0);
            for (Component[] componentRow : componentRows) {
                constraints = layout.getConstraints(componentRow[c]);
                widthSpring = Spring.max(widthSpring, constraints.getWidth());
            }
            for (Component[] componentRow : componentRows) {
                constraints = layout.getConstraints(componentRow[c]);
                constraints.setX(xSpring);
                constraints.setWidth(widthSpring);
            }
            xSpring = Spring.sum(xSpring, widthSpring);
            if (c >= columnCount - 1) continue;
            xSpring = Spring.sum(xSpring, xPadSpring);
        }
        Spring ySpring = Spring.constant(0);
        Spring yPadSpring = Spring.constant(yPad);
        for (int r = 0; r < rowCount; ++r) {
            SpringLayout.Constraints constraints;
            int c;
            Component[] componentRow;
            componentRow = componentRows.get(r);
            Spring heightSpring = Spring.constant(0);
            for (c = 0; c < columnCount; ++c) {
                constraints = layout.getConstraints(componentRow[c]);
                heightSpring = Spring.max(heightSpring, constraints.getHeight());
            }
            for (c = 0; c < columnCount; ++c) {
                constraints = layout.getConstraints(componentRow[c]);
                constraints.setY(ySpring);
                constraints.setHeight(heightSpring);
            }
            ySpring = Spring.sum(ySpring, heightSpring);
            if (r >= rowCount - 1) continue;
            ySpring = Spring.sum(ySpring, yPadSpring);
        }
        SpringLayout.Constraints constraints = layout.getConstraints(rv);
        constraints.setConstraint("East", xSpring);
        constraints.setConstraint("South", ySpring);
        return rv;
    }

    public static Component expandToBounds(Component rv, Container container, int xInset, int yInset) {
        SpringLayout springLayout;
        LayoutManager layout = container.getLayout();
        if (layout instanceof SpringLayout) {
            springLayout = (SpringLayout)layout;
        } else {
            springLayout = new SpringLayout();
            container.setLayout(springLayout);
        }
        springLayout.putConstraint("North", rv, yInset, "North", (Component)container);
        springLayout.putConstraint("West", rv, xInset, "West", (Component)container);
        springLayout.putConstraint("South", rv, -yInset, "South", (Component)container);
        springLayout.putConstraint("East", rv, -xInset, "East", (Component)container);
        return rv;
    }

    public static Component expandToBounds(Component rv, int xInset, int yInset) {
        return SpringUtilities.expandToBounds(rv, rv.getParent(), xInset, yInset);
    }

    public static Component expandToBounds(Component rv, Container container) {
        return SpringUtilities.expandToBounds(rv, rv.getParent(), 0, 0);
    }

    public static Component expandToBounds(Component rv) {
        return SpringUtilities.expandToBounds(rv, rv.getParent(), 0, 0);
    }
}

