/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.swing;

import edu.cmu.cs.dennisc.swing.Tab;
import edu.cmu.cs.dennisc.swing.event.TabEvent;
import edu.cmu.cs.dennisc.swing.event.TabListener;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public abstract class TabbedPane
extends JPanel
implements TabListener {
    private JPanel m_tabsPanel = new JPanel();
    private CardLayout m_cardLayout = new CardLayout();
    private JPanel m_cardPane = new JPanel();
    private List<Tab> m_tabs = new LinkedList<Tab>();
    private Tab selectedTab = null;

    private static String getNameForCardLayout(Tab tab) {
        return Integer.toHexString(tab.hashCode());
    }

    public TabbedPane(boolean isHorizontalFilled) {
        this.setLayout(new BorderLayout());
        if (isHorizontalFilled) {
            this.m_tabsPanel.setLayout(new BoxLayout(this.m_tabsPanel, 2));
        } else {
            this.m_tabsPanel.setLayout(new FlowLayout(0, 0, 0));
        }
        this.add((Component)this.m_tabsPanel, "North");
        this.m_cardPane.setLayout(this.m_cardLayout);
        this.add((Component)this.m_cardPane, "Center");
    }

    public void addTab(Tab tab) {
        this.m_tabs.add(tab);
        this.m_tabsPanel.add(tab);
        tab.addTabListener(this);
        this.m_cardPane.add((Component)tab.getTabPane(), TabbedPane.getNameForCardLayout(tab));
    }

    public void removeTab(Tab tab) {
        tab.removeTabListener(this);
        this.m_tabs.remove(tab);
        this.m_tabsPanel.remove(tab);
        this.m_cardPane.remove(tab.getTabPane());
    }

    public void clearTabs() {
        Tab[] array = new Tab[this.m_tabs.size()];
        this.m_tabs.toArray(array);
        for (Tab tab : array) {
            this.removeTab(tab);
        }
    }

    public int getTabCount() {
        return this.m_tabs.size();
    }

    public Tab getTabAt(int i) {
        return this.m_tabs.get(i);
    }

    public void tabSelected(TabEvent e) {
        this.selectTab((Tab)e.getTypedSource());
    }

    public void tabClosed(TabEvent e) {
        Tab tab = (Tab)e.getTypedSource();
        this.m_tabs.remove(tab);
        if (tab.isSelected() && !this.m_tabs.isEmpty()) {
            this.selectTab(this.m_tabs.get(0));
        }
        this.m_tabsPanel.remove(tab);
        this.m_cardPane.remove(tab.getTabPane());
        this.m_tabsPanel.revalidate();
        this.repaint();
    }

    public void selectTab(Tab tab) {
        if (this.selectedTab != tab) {
            this.selectedTab = tab;
            this.m_cardLayout.show(this.m_cardPane, TabbedPane.getNameForCardLayout(tab));
            for (Tab t : this.m_tabs) {
                t.setSelected(t == tab);
            }
            this.repaint();
        }
    }

    public Tab getSelectedTab() {
        return this.selectedTab;
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        Graphics2D g2 = (Graphics2D)g;
        for (Tab tab : this.m_tabs) {
            if (!tab.isSelected()) continue;
            int x0 = this.m_cardPane.getX();
            int x1 = this.m_cardPane.getX() + this.m_cardPane.getWidth();
            int y = this.m_cardPane.getY();
            g2.setPaint(Color.GRAY);
            g2.drawLine(x0, y, x1, y);
            x0 = tab.getX();
            x1 = tab.getX() + tab.getWidth() - 2;
            g2.setPaint(tab.getTabPane().getBackground());
            g2.drawLine(x0, y, x1, y);
        }
    }
}

