/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.swing.plaf.metal;

import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.OceanTheme;

public class AdjustableFontSizeOceanTheme
extends OceanTheme {
    private float sizeDelta = 0.0f;
    private float sizeMinimum = 0.0f;
    private FontUIResource controlTextFont = null;
    private FontUIResource menuTextFont = null;
    private FontUIResource subTextFont = null;
    private FontUIResource systemTextFont = null;
    private FontUIResource userTextFont = null;
    private FontUIResource windowTitleTextFont = null;

    private FontUIResource createDeltaFontIfNecessary(FontUIResource fontUIResource) {
        FontUIResource rv;
        if (this.sizeDelta != 0.0f) {
            float nextSize = Math.max(this.sizeMinimum, (float)fontUIResource.getSize() + this.sizeDelta);
            rv = new FontUIResource(fontUIResource.deriveFont(nextSize));
        } else {
            rv = fontUIResource;
        }
        return rv;
    }

    public float getSizeMinimum() {
        return this.sizeMinimum;
    }

    public void setSizeMinimum(float sizeMinimum) {
        this.sizeMinimum = sizeMinimum;
    }

    public float getSizeDelta() {
        return this.sizeDelta;
    }

    public void setSizeDelta(float sizeDelta) {
        if (this.sizeDelta != sizeDelta) {
            this.sizeDelta = sizeDelta;
            this.controlTextFont = null;
            this.menuTextFont = null;
            this.subTextFont = null;
            this.systemTextFont = null;
            this.userTextFont = null;
            this.windowTitleTextFont = null;
        }
    }

    public void adjustSizeDelta(float sizeDeltaDelta) {
        this.setSizeDelta(this.sizeDelta + sizeDeltaDelta);
    }

    public FontUIResource getControlTextFont() {
        if (this.controlTextFont == null) {
            this.controlTextFont = this.createDeltaFontIfNecessary(super.getControlTextFont());
        }
        return this.controlTextFont;
    }

    public FontUIResource getMenuTextFont() {
        if (this.menuTextFont == null) {
            this.menuTextFont = this.createDeltaFontIfNecessary(super.getMenuTextFont());
        }
        return this.menuTextFont;
    }

    public FontUIResource getSubTextFont() {
        if (this.subTextFont == null) {
            this.subTextFont = this.createDeltaFontIfNecessary(super.getSubTextFont());
        }
        return this.subTextFont;
    }

    public FontUIResource getSystemTextFont() {
        if (this.systemTextFont == null) {
            this.systemTextFont = this.createDeltaFontIfNecessary(super.getSystemTextFont());
        }
        return this.systemTextFont;
    }

    public FontUIResource getUserTextFont() {
        if (this.userTextFont == null) {
            this.userTextFont = this.createDeltaFontIfNecessary(super.getUserTextFont());
        }
        return this.userTextFont;
    }

    public FontUIResource getWindowTitleFont() {
        if (this.windowTitleTextFont == null) {
            this.windowTitleTextFont = this.createDeltaFontIfNecessary(super.getWindowTitleFont());
        }
        return this.windowTitleTextFont;
    }
}

