/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.texture;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.Tuple3f;
import edu.cmu.cs.dennisc.texture.TextureCoordinate2f;
import java.awt.Point;

public class BarycentricCoordinatesf
implements BinaryEncodableAndDecodable {
    public float t0;
    public float t1;
    public float t2;

    public BarycentricCoordinatesf(Point p0, Point p1, Point p2, Point p) {
        this.set(p0, p1, p2, p);
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.t0 = binaryDecoder.decodeFloat();
        this.t1 = binaryDecoder.decodeFloat();
        this.t2 = binaryDecoder.decodeFloat();
    }

    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.t0);
        binaryEncoder.encode(this.t1);
        binaryEncoder.encode(this.t2);
    }

    public void set(Point p0, Point p1, Point p2, Point p) {
        this.set(p0.x, p0.y, 0.0f, p1.x, p1.y, 0.0f, p2.x, p2.y, 0.0f, p.x, p.y, 0.0f);
    }

    public void set(Tuple3f p0, Tuple3f p1, Tuple3f p2, Tuple3f p) {
        this.set(p0.x, p0.y, p0.z, p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, p.x, p.y, p.z);
    }

    private void set(float x0, float y0, float z0, float x1, float y1, float z1, float x2, float y2, float z2, float x, float y, float z) {
        this.set(x0 - x2, x1 - x2, x2 - x, y0 - y2, y1 - y2, y2 - y, z0 - z2, z1 - z2, z2 - z);
    }

    private void set(float a, float b, float c, float d, float e, float f, float g, float h, float i) {
        this.t0 = (b * (f + i) - c * (e + h)) / (a * (e + h) - b * (d + g));
        this.t1 = (a * (f + i) - c * (d + g)) / (b * (d + g) - a * (e + h));
        this.t2 = 1.0f - (this.t0 + this.t1);
    }

    private static TextureCoordinate2f addMultiply(TextureCoordinate2f rv, float a, TextureCoordinate2f b) {
        rv.u += a * b.u;
        rv.v += a * b.v;
        return rv;
    }

    public TextureCoordinate2f interpolate(TextureCoordinate2f rv, TextureCoordinate2f uv0, TextureCoordinate2f uv1, TextureCoordinate2f uv2) {
        rv.set(0.0f, 0.0f);
        BarycentricCoordinatesf.addMultiply(rv, this.t0, uv0);
        BarycentricCoordinatesf.addMultiply(rv, this.t1, uv1);
        BarycentricCoordinatesf.addMultiply(rv, this.t2, uv2);
        return rv;
    }

    public TextureCoordinate2f interpolate(TextureCoordinate2f uv0, TextureCoordinate2f uv1, TextureCoordinate2f uv2) {
        return this.interpolate(new TextureCoordinate2f(), uv0, uv1, uv2);
    }
}

