/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.ui;

import edu.cmu.cs.dennisc.pattern.Action;
import java.util.Stack;

public abstract class UndoRedoManager {
    private Stack<Action> m_undoStack = new Stack();
    private Stack<Action> m_redoStack = new Stack();

    protected abstract void handleChange();

    public boolean isUndoStackEmpty() {
        return this.m_undoStack.isEmpty();
    }

    public boolean isRedoStackEmpty() {
        return this.m_redoStack.isEmpty();
    }

    public void runAndPush(Action action) {
        action.run();
        this.pushAlreadyRunActionOntoUndoStack(action);
    }

    public void pushAlreadyRunActionOntoUndoStack(Action action) {
        this.m_undoStack.push(action);
        this.m_redoStack.clear();
        this.handleChange();
    }

    public void undo() {
        Action action = this.m_undoStack.pop();
        this.m_redoStack.push(action);
        action.undo();
        this.handleChange();
    }

    public void redo() {
        Action action = this.m_redoStack.pop();
        action.redo();
        this.m_undoStack.push(action);
        this.handleChange();
    }
}

