/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.ui.eula;

import edu.cmu.cs.dennisc.pattern.Validator;
import edu.cmu.cs.dennisc.swing.InputPane;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EULAPane
extends InputPane<Boolean> {
    private JCheckBox accept = new JCheckBox();
    private JCheckBox reject = new JCheckBox();

    public EULAPane(String text) {
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JTextArea headerTextArea = new JTextArea();
        headerTextArea.setText("Please read the following license agreement carefully.");
        headerTextArea.setEditable(false);
        headerTextArea.setLineWrap(true);
        headerTextArea.setWrapStyleWord(true);
        headerTextArea.setOpaque(false);
        JTextArea textArea = new JTextArea();
        textArea.setText(text);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        this.accept.setText("I accept the terms in the License Agreement");
        this.reject.setText("I do not accept the terms in the License Agreement");
        ButtonGroup group = new ButtonGroup();
        this.accept.setSelected(false);
        this.reject.setSelected(true);
        group.add(this.accept);
        group.add(this.reject);
        this.addOKButtonValidator(new Validator(){

            public boolean isValid() {
                return EULAPane.this.accept.isSelected();
            }
        });
        final JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(480, 320));
        headerTextArea.setAlignmentX(0.0f);
        scrollPane.setAlignmentX(0.0f);
        this.accept.setAlignmentX(0.0f);
        this.reject.setAlignmentX(0.0f);
        ChangeListener changeAdapter = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                EULAPane.this.updateOKButton();
            }
        };
        this.accept.addChangeListener(changeAdapter);
        this.reject.addChangeListener(changeAdapter);
        BoxLayout boxLayout = new BoxLayout(this, 3);
        this.setLayout(boxLayout);
        this.add(headerTextArea);
        this.add(scrollPane);
        this.add(this.accept);
        this.add(this.reject);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                scrollPane.getVerticalScrollBar().setValue(0);
            }
        });
    }

    @Override
    protected Boolean getActualInputValue() {
        return this.accept.isSelected();
    }
}

