/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.ui.imageeditor;

import edu.cmu.cs.dennisc.image.ImageUtilities;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class ImagePane
extends JPanel {
    private Image m_image = null;
    public final int UNSPECIFIED = -1;
    private int m_desiredWidth = -1;
    private int m_desiredHeight = -1;

    protected void paintImage(Graphics g, int x, int y, int width, int height) {
        if (this.m_image != null) {
            g.drawImage(this.m_image, x, y, width, height, this);
        } else {
            g.setColor(this.getForeground());
            g.drawRect(x, y, width, height);
        }
    }

    private int getDesiredImageWidth() {
        if (this.m_desiredWidth == -1) {
            if (this.m_image != null) {
                return ImageUtilities.getWidth(this.m_image);
            }
            return 512;
        }
        return this.m_desiredWidth;
    }

    private int getDesiredImageHeight() {
        if (this.m_desiredHeight == -1) {
            if (this.m_image != null) {
                return ImageUtilities.getHeight(this.m_image);
            }
            return 512;
        }
        return this.m_desiredHeight;
    }

    public void setDesiredImageSize(int width, int height) {
        this.m_desiredWidth = width;
        this.m_desiredHeight = height;
    }

    public final void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        Rectangle r = g.getClipBounds();
        g.fillRect(r.x, r.y, r.width, r.height);
        int componentWidth = this.getWidth();
        int componentHeight = this.getHeight();
        int imageWidth = this.getDesiredImageWidth();
        int imageHeight = this.getDesiredImageHeight();
        int imageX = (componentWidth - imageWidth) / 2;
        int imageY = (componentHeight - imageHeight) / 2;
        this.paintImage(g, imageX, imageY, imageWidth, imageHeight);
    }

    public Image accessImage() {
        return this.m_image;
    }

    public void setImage(Image image) {
        this.m_image = image;
        this.repaint();
    }
}

