/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.ui.lookingglass;

import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.AngleInRadians;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.math.rigidbody.TranslationFunction;
import edu.cmu.cs.dennisc.ui.lookingglass.CameraNavigationDerivative;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CameraNavigationFunction
extends TranslationFunction<CameraNavigationDerivative> {
    private static final double DISTANCE_MINIMUM = 4.0;
    private static final double DISTANCE_MAXIMUM = 100.0;
    private static final double FORCE_FOR_ACCELERATION = 4.0;
    private static final double FORCE_FOR_DECELERATION = -8.0;
    private Vector3 m_velocityRequested = new Vector3();
    private double m_distanceRequested = 16.0;
    private double m_yawRequested = Math.PI;
    private double m_pitchRequested = 0.0;
    private boolean m_isForwardKeyPressed = false;
    private boolean m_isBackwardKeyPressed = false;
    private boolean m_isLeftKeyPressed = false;
    private boolean m_isRightKeyPressed = false;

    public void setKeyPressed(int keyCode, boolean isKeyPressed) {
        switch (keyCode) {
            case 38: {
                this.m_isForwardKeyPressed = isKeyPressed;
                break;
            }
            case 40: {
                this.m_isBackwardKeyPressed = isKeyPressed;
                break;
            }
            case 37: {
                this.m_isLeftKeyPressed = isKeyPressed;
                break;
            }
            case 39: {
                this.m_isRightKeyPressed = isKeyPressed;
            }
        }
    }

    @Override
    protected CameraNavigationDerivative newDerivative() {
        return new CameraNavigationDerivative();
    }

    public void requestVelocity(Vector3 velocityRequested) {
        this.m_velocityRequested.set(velocityRequested);
    }

    public void requestVelocity(double x, double y, double z) {
        this.m_velocityRequested.set(x, y, z);
    }

    public void stopImmediately() {
        this.requestVelocity(0.0, 0.0, 0.0);
        this.setVelocity(0.0, 0.0, 0.0);
    }

    public void requestDistance(double distance) {
        this.m_distanceRequested = Math.max(Math.min(distance, 100.0), 4.0);
    }

    public void requestYaw(Angle yaw) {
        this.m_yawRequested = yaw.getAsRadians();
    }

    public void requestDistanceChange(double delta) {
        this.requestDistance(this.m_distanceRequested + delta);
    }

    public void requestTarget(double x, double y, double z) {
        Point3 translation = this.accessTranslation();
        translation.set(x, y, z);
    }

    public void requestOrbit(double yawDelta, double pitchDelta) {
        this.m_yawRequested += yawDelta;
        this.m_pitchRequested += pitchDelta;
    }

    public Angle getYawRequested() {
        return new AngleInRadians(this.m_yawRequested);
    }

    public Angle getPitchRequested() {
        return new AngleInRadians(this.m_pitchRequested);
    }

    public double getDistanceRequested() {
        return this.m_distanceRequested;
    }

    public Point3 accessTargetRequested() {
        return this.accessTranslation();
    }

    public Point3 getTargetRequested(Point3 rv) {
        rv.set(this.accessTargetRequested());
        return rv;
    }

    public Point3 getTargetRequested() {
        return this.getTargetRequested(new Point3());
    }

    private static double getHeight(double distance) {
        double d = distance * 0.1;
        return d * d;
    }

    private static double getPitchMinimum(double height, double distance) {
        return Math.atan2(height, distance);
    }

    @Override
    protected Vector3 getForce(Vector3 rv, double t) {
        double LENGTH_SQUARED_THRESHOLD = 0.25;
        Vector3 velocity = this.accessVelocity();
        if (this.m_velocityRequested.isZero() && velocity.calculateMagnitudeSquared() < 0.25) {
            this.setMomentum(0.0, 0.0, 0.0);
            rv.set(0.0, 0.0, 0.0);
        } else {
            rv.x = this.m_velocityRequested.x > 0.0 ? (this.m_velocityRequested.x > velocity.x ? 4.0 : -8.0) : (this.m_velocityRequested.x > velocity.x ? 8.0 : -4.0);
            rv.y = this.m_velocityRequested.y > 0.0 ? (this.m_velocityRequested.y > velocity.y ? 4.0 : -8.0) : (this.m_velocityRequested.y > velocity.y ? 8.0 : -4.0);
            rv.z = this.m_velocityRequested.z > 0.0 ? (this.m_velocityRequested.z > velocity.z ? 4.0 : -8.0) : (this.m_velocityRequested.z > velocity.z ? 8.0 : -4.0);
        }
        return rv;
    }

    @Override
    protected CameraNavigationDerivative evaluate(CameraNavigationDerivative rv, double t) {
        return super.evaluate(rv, t);
    }

    @Override
    protected CameraNavigationDerivative evaluate(CameraNavigationDerivative rv, double t, double dt, CameraNavigationDerivative derivative) {
        return super.evaluate(rv, t, dt, derivative);
    }

    @Override
    public void update(CameraNavigationDerivative a, CameraNavigationDerivative b, CameraNavigationDerivative c, CameraNavigationDerivative d, double dt) {
        super.update(a, b, c, d, dt);
        double delta = 2.0 * dt;
        Point3 translation = this.accessTranslation();
        translation.y = Math.max(translation.y, 0.0);
        if (this.m_isForwardKeyPressed) {
            translation.z -= delta;
        }
        if (this.m_isBackwardKeyPressed) {
            translation.z += delta;
        }
        if (this.m_isLeftKeyPressed) {
            translation.x -= delta;
        }
        if (this.m_isRightKeyPressed) {
            translation.x += delta;
        }
    }

    @Override
    public void update() {
        super.update();
    }

    public AffineMatrix4x4 getTransformation(AffineMatrix4x4 rv) {
        CameraNavigationFunction.getTransformation(rv, this.m_yawRequested, this.m_pitchRequested, this.m_distanceRequested, this.accessTranslation());
        return rv;
    }

    public AffineMatrix4x4 getTransformation() {
        return this.getTransformation(AffineMatrix4x4.createNaN());
    }

    public static AffineMatrix4x4 getTransformation(AffineMatrix4x4 rv, double yaw, double pitch, double distance, double xTranslation, double yTranslation, double zTranslation) {
        double height = CameraNavigationFunction.getHeight(distance);
        pitch = Math.max(pitch, CameraNavigationFunction.getPitchMinimum(height, distance));
        rv.setIdentity();
        rv.applyRotationAboutYAxis(new AngleInRadians(yaw));
        rv.applyTranslation(0.0, height, distance);
        rv.applyTranslation(xTranslation, yTranslation, zTranslation);
        rv.applyRotationAboutXAxis(new AngleInRadians(-pitch));
        return rv;
    }

    public static AffineMatrix4x4 getTransformation(double yaw, double pitch, double distance, double xTranslation, double yTranslation, double zTranslation) {
        return CameraNavigationFunction.getTransformation(AffineMatrix4x4.createNaN(), yaw, pitch, distance, xTranslation, yTranslation, zTranslation);
    }

    public static AffineMatrix4x4 getTransformation(AffineMatrix4x4 rv, double yaw, double pitch, double distance, Point3 translation) {
        return CameraNavigationFunction.getTransformation(rv, yaw, pitch, distance, translation.x, translation.y, translation.z);
    }

    public static AffineMatrix4x4 getTransformation(double yaw, double pitch, double distance, Point3 translation) {
        return CameraNavigationFunction.getTransformation(AffineMatrix4x4.createNaN(), yaw, pitch, distance, translation);
    }
}

