/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.ui.lookingglass;

import edu.cmu.cs.dennisc.awt.event.MouseEventUtilities;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import edu.cmu.cs.dennisc.math.EulerAngles;
import edu.cmu.cs.dennisc.math.OrthogonalMatrix3x3;
import edu.cmu.cs.dennisc.scenegraph.AsSeenBy;
import edu.cmu.cs.dennisc.scenegraph.Transformable;
import edu.cmu.cs.dennisc.ui.DragAdapter;
import edu.cmu.cs.dennisc.ui.DragStyle;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class LazySusanDragAdapter
extends DragAdapter {
    private Transformable m_lazySusan;
    private double m_radiansPerPixel;
    private static final boolean USE_EULER_ANGLES = true;
    private EulerAngles m_ea0 = null;
    private double m_yaw0 = Double.NaN;

    public LazySusanDragAdapter(Transformable lazySusan, double radiansPerPixel) {
        this.m_lazySusan = lazySusan;
        this.m_radiansPerPixel = radiansPerPixel;
    }

    protected boolean isAcceptable(MouseEvent e) {
        return MouseEventUtilities.isQuoteLeftUnquoteMouseButton(e);
    }

    protected void handleMousePress(Point current, DragStyle dragStyle, boolean isOriginalAsOpposedToStyleChange) {
        EulerAngles ea;
        this.m_ea0 = ea = new EulerAngles(this.m_lazySusan.getLocalTransformation().orientation);
    }

    protected void handleMouseDrag(Point current, int xDeltaSince0, int yDeltaSince0, int xDeltaSincePrevious, int yDeltaSincePrevious, DragStyle dragStyle) {
        double deltaYaw = (double)xDeltaSince0 * this.m_radiansPerPixel;
        EulerAngles ea = new EulerAngles(this.m_ea0);
        double yawInRadians = ea.yaw.getAsRadians();
        boolean isUpsideDownAndBackwardsSoToSpeak = false;
        double EPSILON = 0.01;
        if (EpsilonUtilities.isWithinEpsilon((Number)ea.pitch.getAsRadians(), Math.PI, 0.01) && EpsilonUtilities.isWithinEpsilon((Number)ea.roll.getAsRadians(), Math.PI, 0.01)) {
            isUpsideDownAndBackwardsSoToSpeak = true;
        }
        yawInRadians = isUpsideDownAndBackwardsSoToSpeak ? (yawInRadians -= deltaYaw) : (yawInRadians += deltaYaw);
        ea.yaw.setAsRadians(yawInRadians);
        OrthogonalMatrix3x3 m = new OrthogonalMatrix3x3(ea);
        this.m_lazySusan.setAxesOnly(m, AsSeenBy.PARENT);
    }

    protected Point handleMouseRelease(Point rvCurrent, DragStyle dragStyle, boolean isOriginalAsOpposedToStyleChange) {
        this.m_ea0 = null;
        return rvCurrent;
    }
}

