/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.ui.scenegraph;

import edu.cmu.cs.dennisc.animation.Animator;
import edu.cmu.cs.dennisc.animation.affine.PointOfViewAnimation;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.pattern.Action;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;
import edu.cmu.cs.dennisc.scenegraph.Transformable;

public class SetPointOfViewAction
implements Action {
    private Animator m_animator;
    private Transformable m_sgSubject;
    private ReferenceFrame m_sgAsSeenBy;
    private AffineMatrix4x4 m_undoPOV;
    private AffineMatrix4x4 m_redoPOV;

    public SetPointOfViewAction(Animator animator, Transformable sgSubject, ReferenceFrame sgAsSeenBy, AffineMatrix4x4 undoPOV, AffineMatrix4x4 redoPOV) {
        this.m_animator = animator;
        this.m_sgSubject = sgSubject;
        this.m_sgAsSeenBy = sgAsSeenBy;
        this.m_undoPOV = undoPOV;
        this.m_redoPOV = redoPOV;
    }

    public void run() {
        assert (this.m_undoPOV == null);
        this.m_undoPOV = this.m_sgSubject.getTransformation(this.m_sgAsSeenBy);
        this.redo();
    }

    private void animate(AffineMatrix4x4 pov) {
        if (this.m_animator != null) {
            this.m_animator.invokeAndWait_ThrowRuntimeExceptionsIfNecessary(new PointOfViewAnimation(this.m_sgSubject, this.m_sgAsSeenBy, PointOfViewAnimation.USE_EXISTING_VALUE_AT_RUN_TIME, pov), null);
        }
    }

    public void undo() {
        this.animate(this.m_undoPOV);
    }

    public void redo() {
        this.animate(this.m_redoPOV);
    }
}

