/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.xml;

import edu.cmu.cs.dennisc.io.FileUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtilities {
    private static DocumentBuilderFactory s_documentBuilderFactory = null;
    private static DocumentBuilder s_documentBuilder = null;
    private static TransformerFactory s_transformerFactory = null;
    private static Transformer s_transformer = null;

    private static DocumentBuilderFactory getDocumentBuilderFactory() {
        if (s_documentBuilderFactory == null) {
            s_documentBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return s_documentBuilderFactory;
    }

    private static DocumentBuilder getDocumentBuilder() {
        if (s_documentBuilder == null) {
            try {
                s_documentBuilder = XMLUtilities.getDocumentBuilderFactory().newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                throw new RuntimeException(pce);
            }
        }
        return s_documentBuilder;
    }

    public static Document createDocument() {
        return XMLUtilities.getDocumentBuilder().newDocument();
    }

    private static TransformerFactory getTransformerFactory() {
        if (s_transformerFactory == null) {
            s_transformerFactory = TransformerFactory.newInstance();
        }
        return s_transformerFactory;
    }

    private static Transformer getTransformer() {
        if (s_transformer == null) {
            try {
                s_transformer = XMLUtilities.getTransformerFactory().newTransformer();
            }
            catch (TransformerConfigurationException tce) {
                throw new RuntimeException(tce);
            }
        }
        return s_transformer;
    }

    public static void write(Document xmlDocument, OutputStream os) {
        xmlDocument.getDocumentElement().normalize();
        try {
            StreamResult streamResult = new StreamResult(os);
            XMLUtilities.getTransformer().transform(new DOMSource(xmlDocument), streamResult);
        }
        catch (TransformerException te) {
            throw new RuntimeException(te);
        }
    }

    public static void write(Document xmlDocument, File file) {
        FileUtilities.createParentDirectoriesIfNecessary(file);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            XMLUtilities.write(xmlDocument, fos);
            fos.flush();
            fos.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void write(Document xmlDocument, String path) {
        XMLUtilities.write(xmlDocument, new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document read(InputStream is) {
        try {
            DocumentBuilder documentBuilder;
            DocumentBuilder documentBuilder2 = documentBuilder = XMLUtilities.getDocumentBuilder();
            synchronized (documentBuilder2) {
                Document rv = documentBuilder.parse(is);
                return rv;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (SAXException saxe) {
            throw new RuntimeException(saxe);
        }
    }

    public static Document read(File file) {
        try {
            return XMLUtilities.read(new FileInputStream(file));
        }
        catch (IOException ioe) {
            throw new RuntimeException(file.toString(), ioe);
        }
    }

    public static Document read(String path) {
        return XMLUtilities.read(new File(path));
    }

    public static List<Element> getChildElementsByTagName(Element xmlParent, String tagName) {
        LinkedList<Element> rv = new LinkedList<Element>();
        NodeList nodeList = xmlParent.getChildNodes();
        int N = nodeList.getLength();
        for (int i = 0; i < N; ++i) {
            Element element;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !tagName.equals((element = (Element)node).getTagName())) continue;
            rv.add(element);
        }
        return rv;
    }

    public static Element getSingleChildElementByTagName(Element xmlParent, String tagName) {
        NodeList nodeList = xmlParent.getChildNodes();
        int N = nodeList.getLength();
        for (int i = 0; i < N; ++i) {
            Element element;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !tagName.equals((element = (Element)node).getTagName())) continue;
            return element;
        }
        return null;
    }
}

