/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.zip;

import edu.cmu.cs.dennisc.zip.DataSource;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipUtilities {
    public static HashMap<String, byte[]> extract(InputStream is) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zis = is instanceof ZipInputStream ? (ZipInputStream)is : new ZipInputStream(is);
        HashMap<String, byte[]> filenameToBytesMap = new HashMap<String, byte[]>();
        while ((zipEntry = zis.getNextEntry()) != null) {
            int count;
            String name = zipEntry.getName();
            if (zipEntry.isDirectory()) continue;
            int BUFFER_SIZE = 2048;
            byte[] buffer = new byte[2048];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
            while ((count = zis.read(buffer, 0, 2048)) != -1) {
                baos.write(buffer, 0, count);
            }
            zis.closeEntry();
            filenameToBytesMap.put(name, baos.toByteArray());
        }
        return filenameToBytesMap;
    }

    public static void write(ZipOutputStream zos, DataSource dataSource) throws IOException {
        assert (dataSource != null);
        assert (dataSource.getName() != null);
        ZipEntry snapshotEntry = new ZipEntry(dataSource.getName());
        zos.putNextEntry(snapshotEntry);
        BufferedOutputStream bos = new BufferedOutputStream(zos);
        dataSource.write(bos);
        bos.flush();
        zos.closeEntry();
    }

    public static void zipContentsOfDirectory(String zipPath, String directoryPath) throws IOException {
        File[] files;
        FileOutputStream fos = new FileOutputStream(zipPath);
        ZipOutputStream zos = new ZipOutputStream(fos);
        File directory = new File(directoryPath);
        byte[] buffer = new byte[1024];
        for (File file : files = directory.listFiles()) {
            int bytesRead;
            if (file.isDirectory()) continue;
            FileInputStream fis = new FileInputStream(file);
            ZipEntry zipEntry = new ZipEntry(file.getName());
            zos.putNextEntry(zipEntry);
            while ((bytesRead = fis.read(buffer)) != -1) {
                zos.write(buffer, 0, bytesRead);
            }
            fis.close();
        }
        zos.flush();
        zos.close();
    }
}

