/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.zoot;

import edu.cmu.cs.dennisc.task.TaskObserver;
import edu.cmu.cs.dennisc.zoot.ActionContext;
import edu.cmu.cs.dennisc.zoot.ActionOperation;
import edu.cmu.cs.dennisc.zoot.Context;
import edu.cmu.cs.dennisc.zoot.Edit;
import edu.cmu.cs.dennisc.zoot.ItemSelectionContext;
import edu.cmu.cs.dennisc.zoot.ItemSelectionOperation;
import edu.cmu.cs.dennisc.zoot.Operation;
import edu.cmu.cs.dennisc.zoot.Resolver;
import edu.cmu.cs.dennisc.zoot.ZManager;
import edu.cmu.cs.dennisc.zoot.event.CancelEvent;
import edu.cmu.cs.dennisc.zoot.event.CommitEvent;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractContext<E extends Operation>
implements Context<E> {
    private E operation;
    private Map<Object, Object> map = new HashMap<Object, Object>();
    private boolean isCommitted = false;
    private boolean isCancelled = false;
    private EventObject e;
    private boolean isCancelWorthwhile;

    public AbstractContext(E operation, EventObject e, boolean isCancelWorthwhile) {
        this.operation = operation;
        this.e = e;
        this.isCancelWorthwhile = isCancelWorthwhile;
    }

    @Override
    public E getOperation() {
        return this.operation;
    }

    @Override
    public boolean isCommitted() {
        return this.isCommitted;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public boolean isPending() {
        return !(this.isCommitted() || this.isCancelled());
    }

    @Override
    public void commitAndInvokeDo(Edit edit) {
        assert (this.isPending());
        CommitEvent e = new CommitEvent((Operation)this.operation, this, edit);
        ZManager.fireOperationCommitting(e);
        if (edit != null) {
            edit.doOrRedo(true);
        }
        this.isCommitted = true;
        ZManager.fireOperationCommitted(e);
    }

    @Override
    public void commit() {
        this.commitAndInvokeDo(null);
    }

    @Override
    public void pend(Resolver<? extends Edit, ?> resolver) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PendTaskObserver<E extends Edit, F>
        implements TaskObserver<F> {
            private Context<? extends Operation> context;
            private Resolver<E, F> resolver;
            private E edit;

            public PendTaskObserver(Context<? extends Operation> context, Resolver<E, F> resolver) {
                this.context = context;
                this.resolver = resolver;
                this.edit = this.resolver.createEdit();
                this.edit = this.resolver.initialize(this.edit, this.context, this);
            }

            @Override
            public void handleCompletion(F f) {
                this.edit = this.resolver.handleCompletion(this.edit, f);
                this.context.commitAndInvokeDo((Edit)this.edit);
            }

            @Override
            public void handleCancelation() {
                this.resolver.handleCancelation();
                this.context.cancel();
            }
        }
        new PendTaskObserver(this, resolver);
    }

    @Override
    public void cancel() {
        assert (this.isPending());
        CancelEvent e = new CancelEvent((Operation)this.operation, this);
        ZManager.fireOperationCancelling(e);
        this.isCancelled = true;
        ZManager.fireOperationCancelled(e);
    }

    @Override
    public boolean isCancelWorthwhile() {
        return this.isCancelWorthwhile;
    }

    @Override
    public <E> E get(Object key, Class<E> cls) {
        Object rv = this.get(key);
        if (rv != null) {
            assert (cls.isAssignableFrom(rv.getClass()));
            return (E)rv;
        }
        return null;
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public void put(Object key, Object value) {
        this.map.put(key, value);
    }

    @Override
    public EventObject getEvent() {
        return this.e;
    }

    @Override
    public ActionContext perform(ActionOperation operation, EventObject o, boolean isCancelWorthwhile) {
        return ZManager.performIfAppropriate(operation, o, isCancelWorthwhile);
    }

    @Override
    public ItemSelectionContext perform(ItemSelectionOperation operation, EventObject o, boolean isCancelWorthwhile, Object prevSelection, Object nextSelection) {
        return ZManager.performIfAppropriate(operation, o, isCancelWorthwhile, prevSelection, nextSelection);
    }

    @Override
    public void execute(SwingWorker<?, ?> worker) {
        worker.execute();
    }
}

