/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.zoot;

import edu.cmu.cs.dennisc.equivalence.EquivalenceUtilities;
import edu.cmu.cs.dennisc.lang.ClassUtilities;
import edu.cmu.cs.dennisc.zoot.Context;
import edu.cmu.cs.dennisc.zoot.Operation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOperation
implements Operation {
    private Action actionForConfiguringSwingComponents = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
        }
    };
    private UUID groupUUID;
    private boolean isEnabled = true;
    private String toolTipText = null;
    private List<JComponent> components = new LinkedList<JComponent>();

    public AbstractOperation(UUID groupUUID) {
        this.groupUUID = groupUUID;
    }

    @Override
    public UUID getGroupUUID() {
        return this.groupUUID;
    }

    protected Component getSourceComponent(Context<?> context) {
        if (context != null) {
            EventObject e = context.getEvent();
            return ClassUtilities.getInstance(e.getSource(), Component.class);
        }
        return null;
    }

    public final Action getActionForConfiguringSwing() {
        return this.actionForConfiguringSwingComponents;
    }

    protected final void putValue(String key, Object value) {
        this.actionForConfiguringSwingComponents.putValue(key, value);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(boolean isEnabled) {
        if (this.isEnabled != isEnabled) {
            this.isEnabled = isEnabled;
            List<JComponent> list = this.components;
            synchronized (list) {
                for (JComponent component : this.components) {
                    component.setEnabled(this.isEnabled);
                }
            }
        }
    }

    @Override
    public String getToolTipText() {
        return this.toolTipText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setToolTipText(String toolTipText) {
        if (!EquivalenceUtilities.areEquivalent(this.toolTipText, toolTipText)) {
            this.toolTipText = toolTipText;
            List<JComponent> list = this.components;
            synchronized (list) {
                for (JComponent component : this.components) {
                    component.setToolTipText(this.toolTipText);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComponent(JComponent component) {
        List<JComponent> list = this.components;
        synchronized (list) {
            this.components.add(component);
            component.setEnabled(this.isEnabled);
            component.setToolTipText(this.toolTipText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeComponent(JComponent component) {
        List<JComponent> list = this.components;
        synchronized (list) {
            this.components.remove(component);
        }
    }
}

