/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.zoot;

import edu.cmu.cs.dennisc.zoot.PaintUtilities;
import edu.cmu.cs.dennisc.zoot.Proxy;
import edu.cmu.cs.dennisc.zoot.ZDragComponent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

class DragProxy
extends Proxy {
    private KeyListener keyAdapter = new KeyListener(){

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                DragProxy.this.getDragComponent().handleCancel(e);
            }
        }

        public void keyTyped(KeyEvent e) {
        }
    };
    private boolean isAlphaDesiredWhenOverDropReceptor;
    private final int DROP_SHADOW_SIZE = 6;

    public DragProxy(ZDragComponent dragComponent, boolean isAlphaDesiredWhenOverDropReceptor) {
        super(dragComponent);
        this.isAlphaDesiredWhenOverDropReceptor = isAlphaDesiredWhenOverDropReceptor;
    }

    public int getProxyWidth() {
        return super.getProxyWidth() + 6;
    }

    public int getProxyHeight() {
        return super.getProxyHeight() + 6;
    }

    protected float getAlpha() {
        if (this.isAlphaDesiredWhenOverDropReceptor && this.isOverDropAcceptor()) {
            return 0.5f;
        }
        return 1.0f;
    }

    public void addNotify() {
        super.addNotify();
        this.addKeyListener(this.keyAdapter);
        this.requestFocus();
    }

    public void removeNotify() {
        this.transferFocus();
        this.removeKeyListener(this.keyAdapter);
        super.removeNotify();
    }

    protected void paintProxy(Graphics2D g2) {
        Paint prevPaint = g2.getPaint();
        g2.setPaint(new Color(0, 0, 0, 64));
        g2.translate(6, 6);
        this.fillBounds(g2);
        g2.translate(-6, -6);
        g2.setPaint(prevPaint);
        this.getSubject().print(g2);
        if (this.isCopyDesired()) {
            g2.setPaint(PaintUtilities.getCopyTexturePaint());
            this.fillBounds(g2);
        }
    }
}

