/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.zoot;

import edu.cmu.cs.dennisc.croquet.swing.Pane;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.BorderFactory;

public abstract class ZComponent
extends Pane {
    protected abstract int getInsetTop();

    protected abstract int getInsetLeft();

    protected abstract int getInsetBottom();

    protected abstract int getInsetRight();

    protected abstract void fillBounds(Graphics2D var1, int var2, int var3, int var4, int var5);

    protected abstract void paintPrologue(Graphics2D var1, int var2, int var3, int var4, int var5);

    protected abstract void paintEpilogue(Graphics2D var1, int var2, int var3, int var4, int var5);

    public ZComponent() {
        this.setDoubleBuffered(false);
    }

    private void updateBorderIfNecessary() {
        if (this.getBorder() == null) {
            this.setBorder(BorderFactory.createEmptyBorder(this.getInsetTop(), this.getInsetLeft(), this.getInsetBottom(), this.getInsetRight()));
        }
    }

    protected Paint getForegroundPaint(int x, int y, int width, int height) {
        return this.getForeground();
    }

    protected Paint getBackgroundPaint(int x, int y, int width, int height) {
        return this.getBackground();
    }

    public void doLayout() {
        this.updateBorderIfNecessary();
        super.doLayout();
    }

    public void addNotify() {
        this.updateBorderIfNecessary();
        super.addNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int x = 0;
        int y = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        Paint prevPaint = g2.getPaint();
        try {
            g2.setPaint(this.getBackgroundPaint(x, y, width, height));
            this.paintPrologue(g2, x, y, width, height);
        }
        finally {
            g2.setPaint(prevPaint);
        }
        super.paint(g);
        prevPaint = g2.getPaint();
        g2.setPaint(this.getForegroundPaint(x, y, width, height));
        try {
            this.paintEpilogue(g2, x, y, width, height);
        }
        finally {
            g2.setPaint(prevPaint);
        }
    }
}

