/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.zoot.list;

import edu.cmu.cs.dennisc.awt.event.LenientMouseClickAdapter;
import edu.cmu.cs.dennisc.croquet.swing.BorderPane;
import edu.cmu.cs.dennisc.croquet.swing.GridBagPane;
import edu.cmu.cs.dennisc.zoot.AbstractActionOperation;
import edu.cmu.cs.dennisc.zoot.AbstractEdit;
import edu.cmu.cs.dennisc.zoot.ActionContext;
import edu.cmu.cs.dennisc.zoot.ActionOperation;
import edu.cmu.cs.dennisc.zoot.ZManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Locale;
import java.util.UUID;
import javax.swing.Box;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEditableListLikeSubstancePane<E>
extends BorderPane {
    private Component listLikeSubstance;
    private AddItemOperation addItemOperation;
    private RemoveItemOperation removeItemOperation;
    private ActionOperation editItemOperation;
    private MoveItemUpOperation moveItemUpOperation;
    private MoveItemDownOperation moveItemDownOperation;
    private LenientMouseClickAdapter lenientMouseClickAdapter = new LenientMouseClickAdapter(){

        protected void mouseQuoteClickedUnquote(MouseEvent e, int quoteClickCountUnquote) {
            if (quoteClickCountUnquote == 2) {
                ZManager.performIfAppropriate(AbstractEditableListLikeSubstancePane.this.editItemOperation, (EventObject)e, true);
            }
        }
    };

    protected abstract ActionOperation createEditOperation(UUID var1);

    protected abstract E createItem() throws Exception;

    protected abstract void add(int var1, E var2);

    protected abstract void remove(int var1, E var2);

    protected abstract E getItemAt(int var1);

    protected abstract void setItemsAt(int var1, E var2, E var3);

    protected abstract int getListSize();

    protected abstract int getSelectedIndex();

    protected abstract void setSelectedIndex(int var1);

    public AbstractEditableListLikeSubstancePane(UUID groupUUID, Component listLikeSubstance) {
        this.listLikeSubstance = listLikeSubstance;
        this.addItemOperation = new AddItemOperation(groupUUID, this.getAddItemOperationName());
        this.editItemOperation = this.createEditOperation(groupUUID);
        this.removeItemOperation = new RemoveItemOperation(groupUUID, this.getRemoveItemOperationName());
        this.moveItemUpOperation = new MoveItemUpOperation(groupUUID, this.getMoveItemUpOperationName());
        this.moveItemDownOperation = new MoveItemDownOperation(groupUUID, this.getMoveItemDownOperationName());
        this.setLayout(new BorderLayout(8, 0));
        GridBagPane buttonPane = new GridBagPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridwidth = 0;
        buttonPane.add((Component)ZManager.createButton(this.addItemOperation), gbc);
        buttonPane.add((Component)ZManager.createButton(this.editItemOperation), gbc);
        buttonPane.add((Component)ZManager.createButton(this.removeItemOperation), gbc);
        gbc.insets.top = 8;
        buttonPane.add((Component)ZManager.createButton(this.moveItemUpOperation), gbc);
        gbc.insets.top = 0;
        buttonPane.add((Component)ZManager.createButton(this.moveItemDownOperation), gbc);
        gbc.weighty = 1.0;
        buttonPane.add(Box.createGlue(), gbc);
        this.add((Component)buttonPane, "East");
        JScrollPane scrollPane = new JScrollPane(this.listLikeSubstance);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
    }

    public Component getListLikeSubstance() {
        return this.listLikeSubstance;
    }

    @Override
    public void addNotify() {
        this.updateOperationsEnabledStates();
        this.listLikeSubstance.addMouseListener(this.lenientMouseClickAdapter);
        this.listLikeSubstance.addMouseMotionListener(this.lenientMouseClickAdapter);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        this.listLikeSubstance.removeMouseMotionListener(this.lenientMouseClickAdapter);
        this.listLikeSubstance.removeMouseListener(this.lenientMouseClickAdapter);
        super.removeNotify();
    }

    protected String getAddItemOperationName() {
        return "Add...";
    }

    protected String getRemoveItemOperationName() {
        return "Remove";
    }

    protected String getMoveItemUpOperationName() {
        return "Move Up";
    }

    protected String getMoveItemDownOperationName() {
        return "Move Down";
    }

    protected abstract boolean isEditItemEnabled(int var1);

    protected abstract boolean isRemoveItemEnabled(int var1);

    protected void updateOperationsEnabledStates() {
        boolean isEnabledAtAll = true;
        this.addItemOperation.setEnabled(isEnabledAtAll);
        int index = this.getSelectedIndex();
        int N = this.getListSize();
        this.editItemOperation.setEnabled(isEnabledAtAll && index != -1 && this.isEditItemEnabled(index));
        this.removeItemOperation.setEnabled(isEnabledAtAll && index != -1 && this.isRemoveItemEnabled(index));
        this.moveItemUpOperation.setEnabled(isEnabledAtAll && index > 0);
        this.moveItemDownOperation.setEnabled(isEnabledAtAll && index >= 0 && index < N - 1);
    }

    abstract class AbstractMoveItemOperation
    extends AbstractActionOperation {
        public AbstractMoveItemOperation(UUID groupUUID, String name) {
            super(groupUUID);
            this.putValue("Name", name);
        }

        protected abstract int getIndex(int var1);

        protected abstract int getRedoSelectionIndexDelta();

        protected abstract int getUndoSelectionIndexDelta();

        public final void perform(ActionContext actionContext) {
            final int index = this.getIndex(AbstractEditableListLikeSubstancePane.this.getSelectedIndex());
            actionContext.commitAndInvokeDo(new AbstractEdit(){

                private void swapWithNext(int index2) {
                    if (index2 >= 0) {
                        Object e0 = AbstractEditableListLikeSubstancePane.this.getItemAt(index2);
                        Object e1 = AbstractEditableListLikeSubstancePane.this.getItemAt(index2 + 1);
                        AbstractEditableListLikeSubstancePane.this.setItemsAt(index2, e1, e0);
                    }
                }

                public void doOrRedo(boolean isDo) {
                    this.swapWithNext(index);
                    AbstractEditableListLikeSubstancePane.this.setSelectedIndex(index + AbstractMoveItemOperation.this.getRedoSelectionIndexDelta());
                }

                public void undo() {
                    this.swapWithNext(index);
                    AbstractEditableListLikeSubstancePane.this.setSelectedIndex(index + AbstractMoveItemOperation.this.getUndoSelectionIndexDelta());
                }

                protected StringBuffer updatePresentation(StringBuffer rv, Locale locale) {
                    rv.append("swap items");
                    return rv;
                }
            });
        }
    }

    class AddItemOperation
    extends AbstractActionOperation {
        public AddItemOperation(UUID groupUUID, String name) {
            super(groupUUID);
            this.putValue("Name", name);
        }

        public void perform(ActionContext actionContext) {
            try {
                final Object e = AbstractEditableListLikeSubstancePane.this.createItem();
                final int index = AbstractEditableListLikeSubstancePane.this.getListSize();
                actionContext.commitAndInvokeDo(new AbstractEdit(){

                    public void doOrRedo(boolean isDo) {
                        AbstractEditableListLikeSubstancePane.this.add(index, e);
                    }

                    public void undo() {
                        AbstractEditableListLikeSubstancePane.this.remove(index, e);
                    }

                    protected StringBuffer updatePresentation(StringBuffer rv, Locale locale) {
                        rv.append("add: ");
                        rv.append(e);
                        return rv;
                    }
                });
            }
            catch (Exception e) {
                actionContext.cancel();
            }
        }
    }

    class MoveItemDownOperation
    extends AbstractMoveItemOperation {
        public MoveItemDownOperation(UUID groupUUID, String name) {
            super(groupUUID, name);
        }

        protected int getIndex(int selectedIndex) {
            return selectedIndex;
        }

        public int getRedoSelectionIndexDelta() {
            return 1;
        }

        public int getUndoSelectionIndexDelta() {
            return 0;
        }
    }

    class MoveItemUpOperation
    extends AbstractMoveItemOperation {
        public MoveItemUpOperation(UUID groupUUID, String name) {
            super(groupUUID, name);
        }

        protected int getIndex(int selectedIndex) {
            return selectedIndex - 1;
        }

        public int getRedoSelectionIndexDelta() {
            return 0;
        }

        public int getUndoSelectionIndexDelta() {
            return 1;
        }
    }

    class RemoveItemOperation
    extends AbstractActionOperation {
        public RemoveItemOperation(UUID groupUUID, String name) {
            super(groupUUID);
            this.putValue("Name", name);
        }

        public void perform(ActionContext actionContext) {
            final int index = AbstractEditableListLikeSubstancePane.this.getSelectedIndex();
            if (index < 0) {
                throw new AssertionError();
            }
            final Object e = AbstractEditableListLikeSubstancePane.this.getItemAt(index);
            actionContext.commitAndInvokeDo(new AbstractEdit(){

                public void doOrRedo(boolean isDo) {
                    AbstractEditableListLikeSubstancePane.this.remove(index, e);
                }

                public void undo() {
                    AbstractEditableListLikeSubstancePane.this.add(index, e);
                }

                protected StringBuffer updatePresentation(StringBuffer rv, Locale locale) {
                    rv.append("remove: ");
                    rv.append(e);
                    return rv;
                }
            });
        }
    }
}

