/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact;

import edu.cmu.cs.dennisc.animation.Animator;
import edu.cmu.cs.dennisc.clock.Clock;
import edu.cmu.cs.dennisc.lookingglass.OnscreenLookingGlass;
import edu.cmu.cs.dennisc.lookingglass.PickResult;
import edu.cmu.cs.dennisc.lookingglass.event.AutomaticDisplayEvent;
import edu.cmu.cs.dennisc.lookingglass.event.AutomaticDisplayListener;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.scenegraph.Transformable;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.alice.interact.InputState;
import org.alice.interact.condition.ManipulatorConditionSet;
import org.alice.interact.event.ManipulationEvent;
import org.alice.interact.event.ManipulationEventManager;
import org.alice.interact.event.ManipulationListener;
import org.alice.interact.event.SelectionEvent;
import org.alice.interact.event.SelectionListener;
import org.alice.interact.handle.HandleManager;
import org.alice.interact.handle.HandleSet;
import org.alice.interact.handle.ManipulationHandle;
import org.alice.interact.manipulator.AbstractManipulator;
import org.alice.interact.manipulator.CameraInformedManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDragAdapter
implements MouseWheelListener,
MouseListener,
MouseMotionListener,
KeyListener {
    public static final String BOUNDING_BOX_KEY = "BOUNDING_BOX_KEY";
    protected Vector<ManipulatorConditionSet> manipulators = new Vector();
    protected OnscreenLookingGlass onscreenLookingGlass;
    protected Animator animator;
    private Component lookingGlassComponent = null;
    protected InputState currentInputState = new InputState();
    protected InputState previousInputState = new InputState();
    private double timePrev = Double.NaN;
    private boolean hasSetCameraTransformables = false;
    private Component currentRolloverComponent = null;
    protected HandleManager handleManager = new HandleManager();
    protected ManipulationEventManager manipulationEventManager = new ManipulationEventManager();
    private Transformable selectedObject = null;
    private List<SelectionListener> selectionListeners = new LinkedList<SelectionListener>();
    private AutomaticDisplayListener automaticDisplayAdapter = new AutomaticDisplayListener(){

        public void automaticDisplayCompleted(AutomaticDisplayEvent e) {
            AbstractDragAdapter.this.handleDisplayed();
        }
    };
    private int cameraIndex = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyListener(SelectionListener selectionListener) {
        List<SelectionListener> list = this.selectionListeners;
        synchronized (list) {
            this.selectionListeners.add(selectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionListener(SelectionListener selectionListener) {
        List<SelectionListener> list = this.selectionListeners;
        synchronized (list) {
            this.selectionListeners.remove(selectionListener);
        }
    }

    public Iterable<SelectionListener> getSelectionListeners() {
        return this.selectionListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSelecting(SelectionEvent e) {
        List<SelectionListener> list = this.selectionListeners;
        synchronized (list) {
            for (SelectionListener selectionListener : this.selectionListeners) {
                selectionListener.selecting(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSelected(SelectionEvent e) {
        List<SelectionListener> list = this.selectionListeners;
        synchronized (list) {
            for (SelectionListener selectionListener : this.selectionListeners) {
                selectionListener.selected(e);
            }
        }
    }

    public AbstractDragAdapter() {
        this.setUpControls();
    }

    protected abstract void setUpControls();

    public void triggerManipulationEvent(ManipulationEvent event, boolean isActivate) {
        event.setInputState(this.currentInputState);
        this.manipulationEventManager.triggerEvent(event, isActivate);
    }

    protected Component getAWTComponentToAddListenersTo(OnscreenLookingGlass onscreenLookingGlass) {
        if (onscreenLookingGlass != null) {
            return onscreenLookingGlass.getAWTComponent();
        }
        return null;
    }

    public OnscreenLookingGlass getOnscreenLookingGlass() {
        return this.onscreenLookingGlass;
    }

    public void setOnscreenLookingGlass(OnscreenLookingGlass onscreenLookingGlass) {
        if (this.onscreenLookingGlass != null) {
            this.onscreenLookingGlass.getLookingGlassFactory().removeAutomaticDisplayListener(this.automaticDisplayAdapter);
        }
        this.onscreenLookingGlass = onscreenLookingGlass;
        this.setAWTComponent(this.getAWTComponentToAddListenersTo(this.onscreenLookingGlass));
        if (this.onscreenLookingGlass != null) {
            this.onscreenLookingGlass.getLookingGlassFactory().addAutomaticDisplayListener(this.automaticDisplayAdapter);
        }
    }

    protected Component getAWTComponent() {
        return this.lookingGlassComponent;
    }

    public void setAWTComponent(Component awtComponent) {
        if (this.lookingGlassComponent != null) {
            this.removeListeners(this.lookingGlassComponent);
        }
        this.lookingGlassComponent = awtComponent;
        if (this.lookingGlassComponent != null) {
            this.addListeners(awtComponent);
        }
    }

    public void setAnimator(Animator animator) {
        this.animator = animator;
        this.handleManager.setAnimator(animator);
    }

    public Animator getAnimator() {
        return this.animator;
    }

    public void setSelectedObject(Transformable selected) {
        if (this.selectedObject != selected) {
            this.fireSelecting(new SelectionEvent(this, selected));
            this.handleManager.setSelectedObject(selected);
            this.currentInputState.setCurrentlySelectedObject(selected);
            this.selectedObject = selected;
            this.fireSelected(new SelectionEvent(this, selected));
            this.handleStateChange();
        }
    }

    public void setHandleSet(HandleSet handleSet) {
        this.handleManager.setHandleSet(handleSet);
    }

    public void pushHandleSet(HandleSet handleSet) {
        this.handleManager.pushNewHandleSet(handleSet);
    }

    public HandleSet popHandleSet() {
        return this.handleManager.popHandleSet();
    }

    protected void handleStateChange() {
        int i;
        Vector<AbstractManipulator> toStart = new Vector<AbstractManipulator>();
        Vector<AbstractManipulator> toEnd = new Vector<AbstractManipulator>();
        Vector<AbstractManipulator> toUpdate = new Vector<AbstractManipulator>();
        for (i = 0; i < this.manipulators.size(); ++i) {
            ManipulatorConditionSet currentManipulatorSet = this.manipulators.get(i);
            if (!currentManipulatorSet.stateChanged(this.currentInputState, this.previousInputState)) continue;
            if (currentManipulatorSet.shouldContinue(this.currentInputState, this.previousInputState)) {
                toUpdate.add(currentManipulatorSet.getManipulator());
                continue;
            }
            if (currentManipulatorSet.justStarted(this.currentInputState, this.previousInputState)) {
                toStart.add(currentManipulatorSet.getManipulator());
                continue;
            }
            if (!currentManipulatorSet.justEnded(this.currentInputState, this.previousInputState)) continue;
            toEnd.add(currentManipulatorSet.getManipulator());
        }
        for (i = 0; i < toEnd.size(); ++i) {
            ((AbstractManipulator)toEnd.get(i)).endManipulator(this.currentInputState, this.previousInputState);
        }
        for (i = 0; i < toStart.size(); ++i) {
            ((AbstractManipulator)toStart.get(i)).startManipulator(this.currentInputState);
        }
        for (i = 0; i < toUpdate.size(); ++i) {
            if (toStart.contains(toUpdate.get(i))) {
                ((AbstractManipulator)toUpdate.get(i)).dataUpdateManipulator(this.currentInputState, this.currentInputState);
                continue;
            }
            ((AbstractManipulator)toUpdate.get(i)).dataUpdateManipulator(this.currentInputState, this.previousInputState);
        }
        if (this.currentInputState.getRolloverHandle() != this.previousInputState.getRolloverHandle()) {
            if (this.currentInputState.getRolloverHandle() != null) {
                this.handleManager.setHandleRollover(this.currentInputState.getRolloverHandle(), true);
            }
            if (this.previousInputState.getRolloverHandle() != null) {
                this.handleManager.setHandleRollover(this.previousInputState.getRolloverHandle(), false);
            }
        }
        if (this.currentInputState.getCurrentlySelectedObject() != this.previousInputState.getCurrentlySelectedObject()) {
            this.setSelectedObject(this.currentInputState.getCurrentlySelectedObject());
        }
        this.previousInputState.copyState(this.currentInputState);
    }

    protected void update(double timeDelta) {
        for (int i = 0; i < this.manipulators.size(); ++i) {
            ManipulatorConditionSet currentManipulatorSet = this.manipulators.get(i);
            if (!currentManipulatorSet.getManipulator().hasStarted() || !currentManipulatorSet.shouldContinue(this.currentInputState, this.previousInputState)) continue;
            currentManipulatorSet.getManipulator().timeUpdateManipulator(timeDelta, this.currentInputState);
        }
    }

    public void setSGCamera(AbstractCamera camera) {
        for (int i = 0; i < this.manipulators.size(); ++i) {
            if (!(this.manipulators.get(i).getManipulator() instanceof CameraInformedManipulator)) continue;
            ((CameraInformedManipulator)((Object)this.manipulators.get(i).getManipulator())).setOnscreenLookingGlass(this.getOnscreenLookingGlass());
        }
    }

    protected void handleDisplayed() {
        AbstractCamera sgCamera = this.getSGCamera();
        if (sgCamera != null) {
            if (!this.hasSetCameraTransformables) {
                this.setSGCamera(sgCamera);
                this.hasSetCameraTransformables = true;
            }
            double timeCurr = Clock.getCurrentTime();
            if (sgCamera != null) {
                if (Double.isNaN(this.timePrev)) {
                    this.timePrev = Clock.getCurrentTime();
                }
                double timeDelta = timeCurr - this.timePrev;
                this.update(timeDelta);
            }
            this.timePrev = timeCurr;
        }
    }

    public AbstractCamera getSGCamera() {
        OnscreenLookingGlass onscreenLookingGlass = this.getOnscreenLookingGlass();
        if (onscreenLookingGlass != null) {
            if (this.cameraIndex < onscreenLookingGlass.getCameraCount()) {
                return onscreenLookingGlass.getCameraAt(this.cameraIndex);
            }
            return null;
        }
        return null;
    }

    public Transformable getSGCameraTransformable() {
        AbstractCamera sgCamera = this.getSGCamera();
        if (sgCamera != null) {
            return (Transformable)sgCamera.getParent();
        }
        return null;
    }

    protected boolean isComponentListener(Component component) {
        for (MouseListener mouseListener : component.getMouseListeners()) {
            if (mouseListener != this) continue;
            return true;
        }
        for (EventListener eventListener : component.getMouseMotionListeners()) {
            if (eventListener != this) continue;
            return true;
        }
        for (EventListener eventListener : component.getKeyListeners()) {
            if (eventListener != this) continue;
            return true;
        }
        for (EventListener eventListener : component.getMouseWheelListeners()) {
            if (eventListener != this) continue;
            return true;
        }
        return false;
    }

    public void addManipulator(ManipulatorConditionSet manipulator) {
        this.manipulators.add(manipulator);
    }

    public void addListeners(Component component) {
        if (!this.isComponentListener(component)) {
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
            component.addKeyListener(this);
            component.addMouseWheelListener(this);
        }
    }

    public void removeListeners(Component component) {
        if (this.isComponentListener(component)) {
            component.removeMouseListener(this);
            component.removeMouseMotionListener(this);
            component.removeKeyListener(this);
            component.removeMouseWheelListener(this);
        }
    }

    public void addManipulationListener(ManipulationListener listener) {
        this.manipulationEventManager.addManipulationListener(listener);
    }

    public void removeManipulationListener(ManipulationListener listener) {
        this.manipulationEventManager.removeManipulationListener(listener);
    }

    public void addHandle(ManipulationHandle handle) {
        this.handleManager.addHandle(handle);
    }

    private ManipulationHandle getHandleForComponent(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof ManipulationHandle) {
            return (ManipulationHandle)((Object)c);
        }
        return this.getHandleForComponent(c.getParent());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.currentInputState.setMouseState(e.getButton(), true);
        this.currentInputState.setMouseLocation(e.getPoint());
        this.currentInputState.setInputEventType(InputState.InputEventType.MOUSE_DOWN);
        e.getComponent().requestFocus();
        if (e.getComponent() == this.lookingGlassComponent) {
            this.currentInputState.setClickPickResult(this.pickIntoScene(e.getPoint()));
        } else {
            this.currentInputState.setClickHandle(this.getHandleForComponent(e.getComponent()));
        }
        this.handleStateChange();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.currentInputState.setMouseState(e.getButton(), false);
        this.currentInputState.setMouseLocation(e.getPoint());
        this.currentInputState.setInputEventType(InputState.InputEventType.MOUSE_UP);
        if (this.currentRolloverComponent == this.lookingGlassComponent) {
            this.currentInputState.setRolloverPickResult(this.pickIntoScene(e.getPoint()));
        } else {
            this.currentInputState.setRolloverHandle(this.getHandleForComponent(this.currentRolloverComponent));
        }
        this.handleStateChange();
    }

    private PickResult pickIntoScene(Point mouseLocation) {
        OnscreenLookingGlass onscreenLookingGlass = this.getOnscreenLookingGlass();
        assert (onscreenLookingGlass != null);
        PickResult pickResult = onscreenLookingGlass.pickFrontMost(mouseLocation.x, mouseLocation.y, false);
        return pickResult;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        try {
            this.currentInputState.setMouseLocation(e.getPoint());
            this.currentInputState.setInputEventType(InputState.InputEventType.MOUSE_DRAGGED);
            this.handleStateChange();
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.currentInputState.setMouseLocation(e.getPoint());
        if (e.getComponent() == this.lookingGlassComponent) {
            this.currentInputState.setRolloverPickResult(this.pickIntoScene(e.getPoint()));
        } else {
            this.currentInputState.setRolloverHandle(this.getHandleForComponent(e.getComponent()));
        }
        this.handleStateChange();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.currentInputState.setMouseWheelState(e.getWheelRotation());
        this.currentInputState.setInputEventType(InputState.InputEventType.MOUSE_WHEEL);
        this.handleStateChange();
        this.currentInputState.setMouseWheelState(0);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.currentInputState.setKeyState(e.getKeyCode(), true);
        this.currentInputState.setInputEventType(InputState.InputEventType.KEY_DOWN);
        this.handleStateChange();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.currentInputState.setKeyState(e.getKeyCode(), false);
        this.currentInputState.setInputEventType(InputState.InputEventType.KEY_UP);
        this.handleStateChange();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.currentRolloverComponent = e.getComponent();
        if (!this.currentInputState.isAnyMouseButtonDown()) {
            this.currentInputState.setMouseLocation(e.getPoint());
            if (e.getComponent() == this.lookingGlassComponent) {
                this.currentInputState.setRolloverPickResult(this.pickIntoScene(e.getPoint()));
            } else {
                this.currentInputState.setRolloverHandle(this.getHandleForComponent(e.getComponent()));
            }
            this.handleStateChange();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.currentRolloverComponent = null;
        if (!this.currentInputState.isAnyMouseButtonDown()) {
            this.currentInputState.setMouseLocation(e.getPoint());
            this.currentInputState.setRolloverHandle(null);
            this.currentInputState.setRolloverPickResult(null);
            this.handleStateChange();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

