/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact;

import edu.cmu.cs.dennisc.math.AxisAlignedBox;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import org.alice.interact.AbstractDragAdapter;
import org.alice.interact.MovementDirection;
import org.alice.interact.MovementKey;
import org.alice.interact.MovementType;
import org.alice.interact.PickHint;
import org.alice.interact.condition.KeyPressCondition;
import org.alice.interact.condition.ManipulatorConditionSet;
import org.alice.interact.condition.MouseDragCondition;
import org.alice.interact.condition.MovementDescription;
import org.alice.interact.condition.PickCondition;
import org.alice.interact.manipulator.CameraTranslateKeyManipulator;
import org.alice.interact.manipulator.HandlelessObjectRotateDragManipulator;
import org.alice.interact.manipulator.ObjectRotateKeyManipulator;

public class CreateASimDragAdapter
extends AbstractDragAdapter {
    protected void setUpControls() {
        int i;
        MovementKey[] movementKeys = new MovementKey[]{new MovementKey(33, new MovementDescription(MovementDirection.UP, MovementType.STOOD_UP), 0.35), new MovementKey(38, new MovementDescription(MovementDirection.UP, MovementType.STOOD_UP), 0.35), new MovementKey(34, new MovementDescription(MovementDirection.DOWN, MovementType.STOOD_UP), 0.35), new MovementKey(40, new MovementDescription(MovementDirection.DOWN, MovementType.STOOD_UP), 0.35)};
        MovementKey[] zoomKeys = new MovementKey[]{new MovementKey(45, new MovementDescription(MovementDirection.BACKWARD, MovementType.LOCAL)), new MovementKey(109, new MovementDescription(MovementDirection.BACKWARD, MovementType.LOCAL)), new MovementKey(61, new MovementDescription(MovementDirection.FORWARD, MovementType.LOCAL)), new MovementKey(107, new MovementDescription(MovementDirection.FORWARD, MovementType.LOCAL))};
        MovementKey[] turnKeys = new MovementKey[]{new MovementKey(91, new MovementDescription(MovementDirection.UP, MovementType.ABSOLUTE), -25.0), new MovementKey(37, new MovementDescription(MovementDirection.UP, MovementType.ABSOLUTE), -25.0), new MovementKey(93, new MovementDescription(MovementDirection.UP, MovementType.ABSOLUTE), 25.0), new MovementKey(39, new MovementDescription(MovementDirection.UP, MovementType.ABSOLUTE), 25.0)};
        CameraTranslateKeyManipulator cameraTranslateManip = new CameraTranslateKeyManipulator(movementKeys);
        cameraTranslateManip.addKeys(zoomKeys);
        ManipulatorConditionSet cameraTranslate = new ManipulatorConditionSet(cameraTranslateManip);
        for (i = 0; i < movementKeys.length; ++i) {
            cameraTranslate.addCondition(new KeyPressCondition(movementKeys[i].keyValue));
        }
        for (i = 0; i < zoomKeys.length; ++i) {
            cameraTranslate.addCondition(new KeyPressCondition(zoomKeys[i].keyValue));
        }
        this.manipulators.add(cameraTranslate);
        ManipulatorConditionSet objectRotate = new ManipulatorConditionSet(new ObjectRotateKeyManipulator(turnKeys));
        for (int i2 = 0; i2 < turnKeys.length; ++i2) {
            objectRotate.addCondition(new KeyPressCondition(turnKeys[i2].keyValue));
        }
        this.manipulators.add(objectRotate);
        ManipulatorConditionSet mouseRotateObjectLeftRight = new ManipulatorConditionSet(new HandlelessObjectRotateDragManipulator(MovementDirection.UP));
        MouseDragCondition moveableObjectWithCtrl = new MouseDragCondition(1, new PickCondition(PickHint.EVERYTHING));
        mouseRotateObjectLeftRight.addCondition(moveableObjectWithCtrl);
        this.manipulators.add(mouseRotateObjectLeftRight);
    }

    public void setSGCamera(AbstractCamera camera) {
        super.setSGCamera(camera);
        AxisAlignedBox cameraBounds = new AxisAlignedBox();
        Vector3 cameraBackwards = camera.getAbsoluteTransformation().orientation.backward;
        Point3 cameraMin = new Point3(camera.getAbsoluteTransformation().translation);
        Point3 cameraMax = new Point3(cameraMin);
        double originalY = cameraMin.y;
        cameraMin.add(Vector3.createMultiplication((Tuple3)cameraBackwards, 1.5));
        cameraMin.y = 0.25;
        cameraMax.subtract(Vector3.createMultiplication((Tuple3)cameraBackwards, 4.5));
        cameraMax.y = originalY + 1.5;
        cameraBounds.setMinimum(cameraMin);
        cameraBounds.setMaximum(cameraMax);
        for (int i = 0; i < this.manipulators.size(); ++i) {
            if (!(((ManipulatorConditionSet)this.manipulators.get(i)).getManipulator() instanceof CameraTranslateKeyManipulator)) continue;
            ((CameraTranslateKeyManipulator)((ManipulatorConditionSet)this.manipulators.get(i)).getManipulator()).setBounds(cameraBounds);
        }
    }
}

