/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact;

import edu.cmu.cs.dennisc.math.Vector3;
import org.alice.interact.handle.HandleSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MovementDirection {
    FORWARD(0.0, 0.0, -1.0),
    BACKWARD(0.0, 0.0, 1.0),
    LEFT(-1.0, 0.0, 0.0),
    RIGHT(1.0, 0.0, 0.0),
    UP(0.0, 1.0, 0.0),
    DOWN(0.0, -1.0, 0.0),
    RESIZE(-1.0, 1.0, 0.0);

    private Vector3 directionVector;

    private MovementDirection(double x, double y, double z) {
        this.directionVector = new Vector3(x, y, z);
        this.directionVector.normalize();
    }

    public Vector3 getVector() {
        return this.directionVector;
    }

    public HandleSet.HandleGroup getHandleGroup() {
        if (this == FORWARD || this == BACKWARD) {
            return HandleSet.HandleGroup.Z_AXIS;
        }
        if (this == UP || this == DOWN) {
            return HandleSet.HandleGroup.Y_AXIS;
        }
        if (this == LEFT || this == RIGHT) {
            return HandleSet.HandleGroup.X_AXIS;
        }
        if (this == RESIZE) {
            return HandleSet.HandleGroup.RESIZE_AXIS;
        }
        return null;
    }

    public MovementDirection getOpposite() {
        if (this == FORWARD) {
            return BACKWARD;
        }
        if (this == BACKWARD) {
            return FORWARD;
        }
        if (this == UP) {
            return DOWN;
        }
        if (this == DOWN) {
            return UP;
        }
        if (this == LEFT) {
            return RIGHT;
        }
        if (this == RIGHT) {
            return LEFT;
        }
        return this;
    }

    public boolean hasDirection(Vector3 vector) {
        double dot = Vector3.calculateDotProduct(this.directionVector, vector);
        return dot > 0.0;
    }
}

