/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact;

import edu.cmu.cs.dennisc.scenegraph.Composite;
import edu.cmu.cs.dennisc.scenegraph.Transformable;
import java.util.BitSet;

public class PickHint
extends BitSet {
    public static final String PICK_HINT_KEY = "PICK_HINT_KEY";
    protected static final int NUM_TYPES = PickType.values().length;
    public static final PickHint NOTHING = new PickHint(PickType.NOTHING);
    public static final PickHint MOVEABLE_OBJECTS = new PickHint(PickType.MOVEABLE_OBJECT);
    public static final PickHint HANDLES = new PickHint(PickType.HANDLE);
    public static final PickHint GROUND = new PickHint(PickType.GROUND);
    public static final PickHint LIGHT = new PickHint(PickType.LIGHT);
    public static final PickHint CAMERA = new PickHint(PickType.CAMERA);
    public static final PickHint MULTIMODE_HANDLES = new PickHint(PickType.MUTLIMODE_HANDLE);
    public static final PickHint EVERYTHING = PickHint.createEverythingHint();
    public static final PickHint NON_INTERACTIVE = new PickHint(PickType.NOTHING, PickType.GROUND, PickType.LIGHT, PickType.CAMERA);

    public PickHint() {
        super(NUM_TYPES);
    }

    public PickHint(PickType ... pickTypes) {
        super(NUM_TYPES);
        for (PickType pickType : pickTypes) {
            this.set(pickType.index);
        }
    }

    public static PickHint createEverythingHint() {
        PickHint toReturn = new PickHint();
        for (int i = 0; i < NUM_TYPES; ++i) {
            toReturn.set(i);
        }
        return toReturn;
    }

    public boolean get(PickType pickType) {
        return this.get(pickType.index);
    }

    public Transformable getMatchingTransformable(Composite composite) {
        PickHint pickHint;
        if (composite == null) {
            return null;
        }
        Object pickHintObject = composite.getBonusDataFor(PICK_HINT_KEY);
        if (pickHintObject instanceof PickHint && this.intersects(pickHint = (PickHint)pickHintObject) && composite instanceof Transformable) {
            return (Transformable)composite;
        }
        return this.getMatchingTransformable(composite.getParent());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PickType {
        NOTHING(0),
        MOVEABLE_OBJECT(1),
        GROUND(2),
        HANDLE(3),
        CAMERA(4),
        LIGHT(5),
        MUTLIMODE_HANDLE(6);

        public int index;

        private PickType(int index) {
            this.index = index;
        }
    }
}

