/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact;

import edu.cmu.cs.dennisc.animation.AbstractAnimation;
import edu.cmu.cs.dennisc.animation.AnimationObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TargetBasedAnimation<E>
extends AbstractAnimation {
    protected static final double DEFAULT_SPEED = 12.0;
    private static final double DISTANCE_TO_DONE = 0.001;
    private static final double MAX_FRAME_LENGTH = 0.1;
    protected E targetValue;
    protected E currentValue;
    protected double speed;

    public TargetBasedAnimation() {
        this.speed = 12.0;
    }

    public TargetBasedAnimation(E currentValue) {
        this(currentValue, currentValue, 12.0);
    }

    public TargetBasedAnimation(E currentValue, double speed) {
        this(currentValue, currentValue, speed);
    }

    public TargetBasedAnimation(E currentValue, E targetValue) {
        this(currentValue, targetValue, 12.0);
    }

    public TargetBasedAnimation(E currentValue, E targetValue, double speed) {
        this.currentValue = this.newE(currentValue);
        this.targetValue = this.newE(targetValue);
        this.speed = speed;
    }

    public void setTarget(E target) {
        this.targetValue = this.newE(target);
    }

    public void setCurrentValue(E value) {
        this.currentValue = this.newE(value);
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getSpeed() {
        return this.speed;
    }

    @Override
    protected void epilogue() {
    }

    @Override
    protected void prologue() {
    }

    protected abstract void updateValue(E var1);

    protected abstract double getDistanceToDone();

    public abstract boolean isDone();

    protected abstract E interpolate(E var1, E var2, double var3);

    protected abstract E newE(E var1);

    public void forceValueUpdate() {
        this.updateValue(this.currentValue);
    }

    @Override
    protected double update(double deltaSincePrologue, double deltaSinceLastUpdate, AnimationObserver animationObserver) {
        if (!this.isDone()) {
            if (!Double.isNaN(deltaSinceLastUpdate)) {
                if (deltaSinceLastUpdate > 0.1) {
                    deltaSinceLastUpdate = 0.1;
                }
                this.currentValue = this.interpolate(this.currentValue, this.targetValue, deltaSinceLastUpdate);
            }
            if (this.getDistanceToDone() < 0.001) {
                this.currentValue = this.newE(this.targetValue);
            }
            this.updateValue(this.currentValue);
        }
        return 1.0;
    }
}

