/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.condition;

import java.awt.Point;
import org.alice.interact.InputState;
import org.alice.interact.ModifierMask;
import org.alice.interact.condition.ModifierSensitiveCondition;
import org.alice.interact.condition.PickCondition;

public class MouseDragCondition
extends ModifierSensitiveCondition {
    protected static final double MIN_MOUSE_MOVE = 2.0;
    private int mouseButton = 0;
    private PickCondition pickCondition = null;
    protected Point mouseDownLocation;
    protected boolean hasStarted = false;

    public MouseDragCondition(int mouseButton, PickCondition pickCondition) {
        this(mouseButton, pickCondition, null);
    }

    public MouseDragCondition(int mouseButton, PickCondition pickCondition, ModifierMask modifierMask) {
        super(modifierMask);
        this.pickCondition = pickCondition;
        this.mouseButton = mouseButton;
    }

    public boolean stateChanged(InputState currentState, InputState previousState) {
        return super.stateChanged(currentState, previousState) || !currentState.getMouseLocation().equals(previousState.getMouseLocation());
    }

    protected boolean testState(InputState state) {
        return this.testInputs(state) && this.testPick(state);
    }

    public boolean isRunning(InputState currentState, InputState previousState) {
        return this.hasStarted && this.testState(currentState) && this.testState(previousState);
    }

    public boolean justStarted(InputState currentState, InputState previousState) {
        if (this.testClick(currentState) && !this.testInputs(previousState)) {
            this.mouseDownLocation = new Point(currentState.getMouseLocation());
        }
        if (this.testInputs(currentState) && this.mouseDownLocation != null && currentState.getMouseLocation().distance(this.mouseDownLocation) >= 2.0) {
            this.mouseDownLocation = null;
            this.hasStarted = true;
            return true;
        }
        return false;
    }

    public boolean justEnded(InputState currentState, InputState previousState) {
        if (this.hasStarted && !this.testState(currentState) && this.testState(previousState)) {
            this.hasStarted = false;
            return true;
        }
        return false;
    }

    protected boolean testClick(InputState state) {
        if (this.testInputs(state)) {
            return this.testPick(state);
        }
        return false;
    }

    protected boolean testPick(InputState state) {
        return this.pickCondition.evalutateChain(state);
    }

    protected boolean testMouse(InputState state) {
        return state.isMouseDown(this.mouseButton);
    }

    protected boolean testInputs(InputState state) {
        return super.testState(state) && this.testMouse(state);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PickClasses {
        ANYTHING,
        MOVEABLE_OBJECTS,
        NOTHING;

    }
}

