/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.condition;

import edu.cmu.cs.dennisc.lookingglass.PickResult;
import edu.cmu.cs.dennisc.scenegraph.Component;
import org.alice.interact.InputState;
import org.alice.interact.PickHint;

public class PickCondition {
    protected boolean isNot = false;
    protected PickHint pickHint;
    protected PickCondition nextCondition = null;

    public PickCondition(PickHint pickHint) {
        this.pickHint = pickHint;
    }

    public PickCondition(PickHint pickHint, PickCondition previousCondition) {
        this(pickHint);
        previousCondition.setNextCondition(this);
    }

    public void setNextCondition(PickCondition nextCondition) {
        this.nextCondition = nextCondition;
    }

    public static PickHint getPickType(PickResult pickObject) {
        boolean isNull;
        boolean bl = isNull = pickObject == null || pickObject.getGeometry() == null || pickObject.getVisual() == null;
        if (isNull) {
            return PickHint.NOTHING;
        }
        return PickCondition.getPickType(pickObject.getVisual());
    }

    public static PickHint getPickType(Component pickedObject) {
        if (pickedObject == null) {
            return PickHint.NOTHING;
        }
        Object bonusData = pickedObject.getBonusDataFor("PICK_HINT_KEY");
        if (bonusData instanceof PickHint) {
            return (PickHint)bonusData;
        }
        return PickCondition.getPickType(pickedObject.getParent());
    }

    public boolean evaluateObject(InputState input) {
        boolean result = false;
        result = input.getClickHandle() != null ? (input.getClickHandle().isPickable() ? this.pickHint.intersects(input.getClickHandle().getPickHint()) : false) : this.pickHint.intersects(PickCondition.getPickType(input.getClickPickResult()));
        if (this.isNot) {
            result = !result;
        }
        return result;
    }

    public boolean evaluateObject(PickResult pickObject) {
        boolean result = this.pickHint.intersects(PickCondition.getPickType(pickObject));
        if (this.isNot) {
            result = !result;
        }
        return result;
    }

    public boolean evalutateChain(PickResult pickObject) {
        if (this.nextCondition == null) {
            return this.evaluateObject(pickObject);
        }
        return this.evaluateObject(pickObject) && this.nextCondition.evalutateChain(pickObject);
    }

    public boolean evalutateChain(InputState input) {
        if (this.nextCondition == null) {
            return this.evaluateObject(input);
        }
        return this.evaluateObject(input) && this.nextCondition.evalutateChain(input);
    }
}

