/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.handle;

import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.AxisAlignedBox;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.property.event.PropertyEvent;
import edu.cmu.cs.dennisc.property.event.PropertyListener;
import edu.cmu.cs.dennisc.scenegraph.AsSeenBy;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;
import edu.cmu.cs.dennisc.scenegraph.Transformable;
import org.alice.interact.DoubleTargetBasedAnimation;
import org.alice.interact.MovementDirection;
import org.alice.interact.MovementType;
import org.alice.interact.condition.MovementDescription;
import org.alice.interact.handle.HandleRenderState;
import org.alice.interact.handle.ManipulationHandle3D;

public abstract class LinearDragHandle
extends ManipulationHandle3D
implements PropertyListener {
    protected static final double MIN_LENGTH = 0.4;
    protected double offsetPadding = 0.0;
    protected MovementDescription dragDescription;
    protected Vector3 dragAxis;
    protected double distanceFromOrigin;
    protected Transformable standUpReference = new Transformable();
    protected DoubleTargetBasedAnimation lengthAnimation;

    public LinearDragHandle() {
        this(new MovementDescription(MovementDirection.UP, MovementType.ABSOLUTE));
    }

    public LinearDragHandle(MovementDescription dragDescription) {
        this.dragDescription = dragDescription;
        this.dragAxis = new Vector3(this.dragDescription.direction.getVector());
        this.localTransformation.setValue(this.getTransformationForAxis(this.dragAxis));
        this.distanceFromOrigin = 0.0;
        this.createShape();
    }

    public LinearDragHandle(LinearDragHandle handle) {
        this(handle.dragDescription);
        this.initFromHandle(handle);
        this.distanceFromOrigin = handle.distanceFromOrigin;
        this.offsetPadding = handle.offsetPadding;
    }

    public MovementDescription getMovementDescription() {
        return this.dragDescription;
    }

    protected abstract void createShape();

    protected void createAnimations() {
        super.createAnimations();
        this.lengthAnimation = new DoubleTargetBasedAnimation(new Double(this.distanceFromOrigin)){

            protected void updateValue(Double value) {
                LinearDragHandle.this.setSize(value);
            }
        };
        this.animator.invokeLater(this.lengthAnimation, null);
    }

    protected void setSize(double size) {
        this.distanceFromOrigin = size;
        this.positionRelativeToObject();
    }

    protected double getHandleLength() {
        if (this.manipulatedObject != null) {
            AxisAlignedBox boundingBox = this.getManipulatedObjectBox();
            Vector3 desiredHandleValues = new Vector3(0.0, 0.0, 0.0);
            Point3 max = boundingBox.getMaximum();
            Point3 min = boundingBox.getMinimum();
            Vector3[] extents = new Vector3[]{new Vector3(max.x, 0.0, 0.0), new Vector3(0.0, max.y, 0.0), new Vector3(0.0, 0.0, max.z), new Vector3(min.x, 0.0, 0.0), new Vector3(0.0, min.y, 0.0), new Vector3(0.0, 0.0, min.z)};
            for (int i = 0; i < extents.length; ++i) {
                double axisDot = Vector3.calculateDotProduct(this.dragAxis, extents[i]);
                if (!(axisDot > 0.0)) continue;
                desiredHandleValues.add(Vector3.createMultiplication((Tuple3)extents[i], this.dragAxis));
            }
            return desiredHandleValues.calculateMagnitude();
        }
        return 0.0;
    }

    public void setManipulatedObject(Transformable manipulatedObject) {
        if (this.manipulatedObject != manipulatedObject) {
            if (this.manipulatedObject != null) {
                this.manipulatedObject.localTransformation.removePropertyListener(this);
            }
            super.setManipulatedObject(manipulatedObject);
            if (this.manipulatedObject != null) {
                this.manipulatedObject.localTransformation.addPropertyListener(this);
            }
        }
    }

    public double getCurrentHandleLength() {
        return this.distanceFromOrigin;
    }

    protected void updateVisibleState(HandleRenderState renderState) {
        super.updateVisibleState(renderState);
        if (this.manipulatedObject != null && this.lengthAnimation != null) {
            double endHandleLength = this.isRenderable() ? this.getHandleLength() : 0.0;
            this.lengthAnimation.setTarget(endHandleLength);
        }
    }

    public Vector3 getDragAxis() {
        return this.dragAxis;
    }

    public ReferenceFrame getReferenceFrame() {
        if (this.manipulatedObject != null) {
            if (this.dragDescription.type == MovementType.STOOD_UP) {
                this.standUpReference.setParent(this.manipulatedObject);
                this.standUpReference.localTransformation.setValue(AffineMatrix4x4.createIdentity());
                this.standUpReference.setAxesOnlyToStandUp();
                return this.standUpReference;
            }
            if (this.dragDescription.type == MovementType.ABSOLUTE) {
                this.standUpReference.setParent(this.manipulatedObject.getRoot());
                AffineMatrix4x4 location = AffineMatrix4x4.createIdentity();
                location.translation.set(this.manipulatedObject.getTranslation(AsSeenBy.SCENE));
                this.standUpReference.localTransformation.setValue(location);
                return this.standUpReference;
            }
            return this.manipulatedObject;
        }
        return this;
    }

    public void positionRelativeToObject() {
        if (this.manipulatedObject != null) {
            Vector3 translation = Vector3.createMultiplication((Tuple3)this.dragAxis, this.distanceFromOrigin + this.offsetPadding);
            this.setTransformation(this.getTransformationForAxis(this.dragAxis), this.getReferenceFrame());
            this.setTranslationOnly(translation, this.getReferenceFrame());
        }
    }

    public void resizeToObject() {
        if (this.manipulatedObject != null) {
            double handleLength = this.getHandleLength();
            this.setSize(handleLength);
            if (this.lengthAnimation != null) {
                this.lengthAnimation.setCurrentValue(this.distanceFromOrigin);
                this.lengthAnimation.setTarget(this.distanceFromOrigin);
            }
        }
    }

    public void propertyChanged(PropertyEvent e) {
        this.positionRelativeToObject();
    }

    public void propertyChanging(PropertyEvent e) {
    }
}

