/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.handle;

import edu.cmu.cs.dennisc.awt.ColorUtilities;
import edu.cmu.cs.dennisc.color.Color4f;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.AxisAlignedBox;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.scenegraph.Cylinder;
import edu.cmu.cs.dennisc.scenegraph.Transformable;
import edu.cmu.cs.dennisc.scenegraph.util.Arrow;
import java.awt.Color;
import org.alice.interact.MovementDirection;
import org.alice.interact.condition.MovementDescription;
import org.alice.interact.handle.HandleRenderState;
import org.alice.interact.handle.LinearDragHandle;

public class LinearScaleHandle
extends LinearDragHandle {
    protected Arrow arrow;
    protected Color4f baseColor;
    protected Transformable standUpReference = new Transformable();
    protected boolean applyAlongAxis = false;

    public LinearScaleHandle(MovementDescription dragDescription, Color4f color) {
        this(dragDescription, color, false);
    }

    public LinearScaleHandle(MovementDescription dragDescription, Color4f color, boolean applyAlongAxis) {
        super(dragDescription);
        this.baseColor = color;
        this.applyAlongAxis = applyAlongAxis;
        this.initializeAppearance();
    }

    public LinearScaleHandle(LinearScaleHandle handle) {
        super(handle);
        this.baseColor = handle.baseColor;
        this.applyAlongAxis = handle.applyAlongAxis;
        this.initializeAppearance();
    }

    public LinearScaleHandle clone() {
        LinearScaleHandle newHandle = new LinearScaleHandle(this);
        return newHandle;
    }

    public boolean applyAlongAxis() {
        return this.applyAlongAxis;
    }

    protected void createShape() {
        this.createShape(1.0);
    }

    protected void createShape(double scale) {
        this.arrow = new Arrow(0.05 * scale, 0.1 * scale, 0.15 * scale, 0.15 * scale, Cylinder.BottomToTopAxis.POSITIVE_Y, this.sgFrontFacingAppearance, true);
        this.arrow.setParent(this);
    }

    protected Vector3 getUniformResizeOffset() {
        Vector3 handleOffset;
        AxisAlignedBox bbox = this.getManipulatedObjectBox();
        if (bbox != null) {
            handleOffset = new Vector3(bbox.getMaximum());
            handleOffset.z = 0.0;
            handleOffset.x *= -1.0;
        } else {
            handleOffset = new Vector3(1.0, 1.0, 0.0);
        }
        return handleOffset;
    }

    protected Vector3 getUniformResizeDirection() {
        Vector3 direction = this.getUniformResizeOffset();
        direction.normalize();
        return direction;
    }

    public void positionRelativeToObject() {
        AffineMatrix4x4 objectTransformation;
        if (this.dragDescription.direction == MovementDirection.RESIZE) {
            this.dragAxis = this.getUniformResizeDirection();
        }
        if ((objectTransformation = this.getTransformationForAxis(this.dragAxis)).isNaN()) {
            assert (!objectTransformation.isNaN()) : "Created NaN transformation from " + this.dragAxis;
            objectTransformation = new AffineMatrix4x4();
        }
        this.setTransformation(objectTransformation, this.getReferenceFrame());
        Vector3 handleOffset = new Vector3(this.dragAxis);
        handleOffset.multiply(this.getHandleLength());
        this.setTranslationOnly(handleOffset, this.getReferenceFrame());
    }

    protected Color4f getBaseColor() {
        if (this.baseColor == null) {
            return super.getBaseColor();
        }
        return this.baseColor;
    }

    protected Color4f getDesiredColor(HandleRenderState renderState) {
        Color desiredColor = new Color(this.getBaseColor().red, this.getBaseColor().green, this.getBaseColor().blue);
        switch (renderState) {
            case NOT_VISIBLE: {
                break;
            }
            case VISIBLE_BUT_SIBLING_IS_ACTIVE: {
                ColorUtilities.shiftHSB(desiredColor, 0.0, -0.6, -0.5);
                break;
            }
            case VISIBLE_AND_ACTIVE: {
                desiredColor = ColorUtilities.shiftHSB(desiredColor, 0.0, 0.0, 0.1);
                break;
            }
            case VISIBLE_AND_ROLLOVER: {
                desiredColor = ColorUtilities.shiftHSB(desiredColor, 0.0, -0.4, -0.3);
                break;
            }
            case JUST_VISIBLE: {
                break;
            }
        }
        return new Color4f(desiredColor);
    }

    protected void setScale(double scale) {
        if (this.arrow != null) {
            this.arrow.setParent(null);
        }
        this.createShape(scale);
    }
}

