/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.handle;

import edu.cmu.cs.dennisc.color.Color4f;
import edu.cmu.cs.dennisc.math.AxisAlignedBox;
import edu.cmu.cs.dennisc.math.Plane;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;
import edu.cmu.cs.dennisc.scenegraph.Sphere;
import edu.cmu.cs.dennisc.scenegraph.Torus;
import edu.cmu.cs.dennisc.scenegraph.Transformable;
import edu.cmu.cs.dennisc.scenegraph.Visual;
import org.alice.interact.DoubleTargetBasedAnimation;
import org.alice.interact.MovementDirection;
import org.alice.interact.PlaneUtilities;
import org.alice.interact.VectorUtilities;
import org.alice.interact.handle.HandleRenderState;
import org.alice.interact.handle.ManipulationHandle3D;

public class RotationRingHandle
extends ManipulationHandle3D {
    protected static final double MINOR_RADIUS = 0.075;
    protected static final double MIN_RADIUS = 0.4;
    protected static final Color4f ACTIVE_COLOR = new Color4f(0.4f, 1.0f, 0.3f, 1.0f);
    protected static final Color4f ROLLOVER_COLOR = new Color4f(1.0f, 1.0f, 0.3f, 1.0f);
    protected static final Color4f MUTED_COLOR = new Color4f(0.5f, 0.5f, 0.4f, 1.0f);
    protected static final Color4f BASE_COLOR = new Color4f(0.7f, 0.7f, 0.3f, 1.0f);
    protected Torus sgTorus = new Torus();
    protected Sphere sgSphere = new Sphere();
    protected Transformable sphereTransformable = new Transformable();
    protected Visual sgSphereVisual = new Visual();
    protected Vector3 rotationAxis;
    protected MovementDirection rotationAxisDirection;
    protected Vector3 sphereDirection = new Vector3();
    protected Vector3 handleOffset = new Vector3();
    protected HandlePosition handlePosition = HandlePosition.ORIGIN;
    protected DoubleTargetBasedAnimation radiusAnimation;

    public RotationRingHandle() {
        this(MovementDirection.UP, HandlePosition.ORIGIN);
    }

    public RotationRingHandle(MovementDirection rotationAxisDirection) {
        this(rotationAxisDirection, HandlePosition.ORIGIN);
    }

    public RotationRingHandle(MovementDirection rotationAxisDirection, HandlePosition handlePosition) {
        this.sgSphereVisual.frontFacingAppearance.setValue(this.sgFrontFacingAppearance);
        this.sgSphereVisual.setParent(this.sphereTransformable);
        this.sphereTransformable.setParent(this);
        this.sgSphereVisual.geometries.setValue((Geometry)new Geometry[]{this.sgSphere});
        this.sgTorus.minorRadius.setValue(0.075);
        this.sgTorus.majorRadius.setValue(0.0);
        this.sgSphere.radius.setValue(0.15);
        this.setSphereVisibility(false);
        this.rotationAxisDirection = rotationAxisDirection;
        this.rotationAxis = this.rotationAxisDirection.getVector();
        this.rotationAxis.normalize();
        this.sphereDirection.set(0.0, 0.0, -1.0);
        this.handlePosition = handlePosition;
        this.localTransformation.setValue(this.getTransformationForAxis(this.rotationAxis));
        this.sgVisual.geometries.setValue((Geometry)new Geometry[]{this.sgTorus});
    }

    public RotationRingHandle(RotationRingHandle handle) {
        this(handle.rotationAxisDirection, handle.handlePosition);
        this.initFromHandle(handle);
        this.handleOffset.set(handle.handleOffset);
    }

    public RotationRingHandle clone() {
        RotationRingHandle newHandle = new RotationRingHandle(this);
        return newHandle;
    }

    protected void setPositionRelativeToObjectSize() {
        if (this.manipulatedObject != null) {
            AxisAlignedBox bbox = this.getManipulatedObjectBox();
            Vector3 maxVector = VectorUtilities.projectOntoVector(new Vector3(bbox.getMaximum()), this.rotationAxis);
            Vector3 minVector = VectorUtilities.projectOntoVector(new Vector3(bbox.getMinimum()), this.rotationAxis);
            this.handleOffset.set(0.0, 0.0, 0.0);
            switch (this.handlePosition) {
                case TOP: {
                    this.handleOffset.set(maxVector);
                    double handleSize = (Double)this.sgTorus.minorRadius.getValue();
                    Vector3 sizeOffset = new Vector3(this.rotationAxis);
                    sizeOffset.normalize();
                    sizeOffset.multiply(-handleSize);
                    this.handleOffset.add(sizeOffset);
                    break;
                }
                case MIDDLE: {
                    this.handleOffset.set(maxVector);
                    this.handleOffset.add(minVector);
                    this.handleOffset.multiply(0.5);
                    break;
                }
                case BOTTOM: {
                    this.handleOffset.set(minVector);
                    double handleSize = (Double)this.sgTorus.minorRadius.getValue();
                    Vector3 sizeOffset = new Vector3(this.rotationAxis);
                    sizeOffset.normalize();
                    sizeOffset.multiply(handleSize);
                    this.handleOffset.add(sizeOffset);
                }
            }
            if (this.handleOffset.isNaN()) {
                this.handleOffset.set(0.0, 0.0, 0.0);
            }
            this.setTranslationOnly(this.handleOffset, this.getReferenceFrame());
        }
    }

    public void setManipulatedObject(Transformable manipulatedObject) {
        super.setManipulatedObject(manipulatedObject);
        this.setPositionRelativeToObjectSize();
    }

    public void setSphereVisibility(boolean showSphere) {
        this.sgSphereVisual.isShowing.setValue(showSphere);
    }

    public void setSphereDirection(Vector3 direction) {
        this.sphereDirection = direction;
        this.placeSphere();
    }

    public Point3 getSphereLocation(ReferenceFrame referenceFrame) {
        return this.sphereTransformable.getTranslation(referenceFrame);
    }

    protected void placeSphere() {
        this.sphereTransformable.setTranslationOnly(Point3.createMultiplication((Tuple3)this.sphereDirection, (Double)this.sgTorus.majorRadius.getValue()), this);
    }

    protected void createAnimations() {
        super.createAnimations();
        double currentRadius = (Double)this.sgTorus.majorRadius.getValue();
        if (Double.isNaN(currentRadius)) {
            currentRadius = 0.0;
        }
        this.radiusAnimation = new DoubleTargetBasedAnimation(new Double(currentRadius)){

            protected void updateValue(Double value) {
                if (RotationRingHandle.this.sgTorus != null) {
                    if (value.isNaN()) {
                        value = 0.0;
                    }
                    if (value < 0.0) {
                        value = 0.0;
                    }
                    RotationRingHandle.this.setSize(value);
                }
            }
        };
        this.animator.invokeLater(this.radiusAnimation, null);
    }

    protected void updateVisibleState(HandleRenderState renderState) {
        super.updateVisibleState(renderState);
        if (this.manipulatedObject != null && this.radiusAnimation != null) {
            double endRadius = this.isRenderable() ? this.getMajorAxisRadius() : 0.0;
            this.radiusAnimation.setTarget(endRadius);
        }
    }

    protected Color4f getDesiredColor(HandleRenderState renderState) {
        switch (renderState) {
            case NOT_VISIBLE: {
                return BASE_COLOR;
            }
            case VISIBLE_BUT_SIBLING_IS_ACTIVE: {
                return MUTED_COLOR;
            }
            case VISIBLE_AND_ACTIVE: {
                return ACTIVE_COLOR;
            }
            case VISIBLE_AND_ROLLOVER: {
                return ROLLOVER_COLOR;
            }
            case JUST_VISIBLE: {
                return BASE_COLOR;
            }
        }
        return BASE_COLOR;
    }

    private void setSize(double size) {
        this.sgTorus.majorRadius.setValue(size);
        this.placeSphere();
    }

    private double getMajorAxisRadius() {
        if (this.manipulatedObject != null) {
            double maxSize;
            AxisAlignedBox boundingBox = this.getManipulatedObjectBox();
            Plane planeOfRotation = new Plane(Point3.createZero(), this.rotationAxis);
            Point3 minPlanePoint = PlaneUtilities.projectPointIntoPlane(planeOfRotation, boundingBox.getMinimum());
            Point3 maxPlanePoint = PlaneUtilities.projectPointIntoPlane(planeOfRotation, boundingBox.getMaximum());
            double minSize = minPlanePoint.calculateMagnitude();
            double radius = Math.max(minSize, maxSize = maxPlanePoint.calculateMagnitude());
            if (Double.isNaN(radius) || radius < 0.4) {
                radius = 0.4;
            }
            return radius;
        }
        return 0.0;
    }

    public Vector3 getRotationAxis() {
        return this.rotationAxis;
    }

    public MovementDirection getRotationDirection() {
        return this.rotationAxisDirection;
    }

    public void positionRelativeToObject() {
    }

    public void resizeToObject() {
        this.setPositionRelativeToObjectSize();
        double radius = this.getMajorAxisRadius();
        this.setSize(radius);
        if (this.radiusAnimation != null) {
            this.radiusAnimation.setCurrentValue(radius);
            this.radiusAnimation.setTarget(radius);
        }
    }

    protected void setScale(double scale) {
        if (this.sgTorus != null) {
            this.sgTorus.minorRadius.setValue(0.075 * scale);
        }
        if (this.sgSphere != null) {
            this.sgSphere.radius.setValue(0.15 * scale);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HandlePosition {
        ORIGIN,
        TOP,
        BOTTOM,
        MIDDLE;

    }
}

