/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.manipulator;

import edu.cmu.cs.dennisc.alice.Project;
import edu.cmu.cs.dennisc.animation.Animator;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import edu.cmu.cs.dennisc.scenegraph.Transformable;
import edu.cmu.cs.dennisc.zoot.ZManager;
import java.util.List;
import java.util.Vector;
import org.alice.interact.AbstractDragAdapter;
import org.alice.interact.InputState;
import org.alice.interact.event.ManipulationEvent;
import org.alice.interact.handle.HandleSet;
import org.alice.interact.operations.PredeterminedSetLocalTransformationActionOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractManipulator {
    protected Transformable manipulatedTransformable = null;
    protected AffineMatrix4x4 originalTransformation = null;
    private boolean hasStarted = false;
    protected AbstractDragAdapter dragAdapter;
    protected boolean hasDoneUpdate = false;
    protected List<ManipulationEvent> manipulationEvents = new Vector<ManipulationEvent>();

    public void setManipulatedTransformable(Transformable manipulatedTransformable) {
        this.manipulatedTransformable = manipulatedTransformable;
    }

    public Transformable getManipulatedTransformable() {
        return this.manipulatedTransformable;
    }

    public boolean hasStarted() {
        return this.hasStarted;
    }

    public boolean hasUpdated() {
        return this.hasDoneUpdate;
    }

    protected void setHasUpdated(boolean hasUpdated) {
        this.hasDoneUpdate = hasUpdated;
    }

    public void setDragAdapter(AbstractDragAdapter dragAdapter) {
        this.dragAdapter = dragAdapter;
    }

    protected abstract HandleSet getHandleSetToEnable();

    protected void initializeEventMessages() {
        this.manipulationEvents.clear();
    }

    public List<ManipulationEvent> getManipulationEvents() {
        this.initializeEventMessages();
        return this.manipulationEvents;
    }

    public void triggerAllDeactivateEvents() {
        for (int i = 0; i < this.manipulationEvents.size(); ++i) {
            this.dragAdapter.triggerManipulationEvent(this.manipulationEvents.get(i), false);
        }
    }

    public void startManipulator(InputState startInput) {
        this.hasStarted = this.doStartManipulator(startInput);
        this.setHasUpdated(false);
        if (this.hasStarted) {
            this.undoRedoBeginManipulation();
            HandleSet setToShow = this.getHandleSetToEnable();
            if (setToShow != null && this.dragAdapter != null) {
                this.dragAdapter.pushHandleSet(setToShow);
            }
        }
    }

    public void dataUpdateManipulator(InputState currentInput, InputState previousInput) {
        if (this.hasStarted) {
            this.doDataUpdateManipulator(currentInput, previousInput);
            this.setHasUpdated(true);
        }
    }

    public void timeUpdateManipulator(double dTime, InputState currentInput) {
        if (this.hasStarted) {
            this.doTimeUpdateManipulator(dTime, currentInput);
            this.setHasUpdated(true);
        }
    }

    public void endManipulator(InputState endInput, InputState previousInput) {
        AffineMatrix4x4 newTransformation;
        this.doEndManipulator(endInput, previousInput);
        if (this.isUndoable()) {
            this.undoRedoEndManipulation();
        } else if (this.getManipulatedTransformable() != null && !(newTransformation = this.getManipulatedTransformable().getLocalTransformation()).equals(this.originalTransformation)) {
            PrintUtilities.println("Skipping undoable action for a manipulation that actually changed the transformation.");
        }
        if (this.hasStarted) {
            this.hasStarted = false;
            HandleSet setToShow = this.getHandleSetToEnable();
            if (setToShow != null && this.dragAdapter != null) {
                this.dragAdapter.popHandleSet();
            }
        }
        this.triggerAllDeactivateEvents();
    }

    public abstract String getUndoRedoDescription();

    public String toString() {
        return this.getClass().toString() + ":" + this.hashCode();
    }

    public void undoRedoBeginManipulation() {
        if (this.getManipulatedTransformable() != null) {
            this.originalTransformation = this.getManipulatedTransformable().getLocalTransformation();
        }
    }

    public void undoRedoEndManipulation() {
        if (this.getManipulatedTransformable() != null) {
            AffineMatrix4x4 newTransformation = this.getManipulatedTransformable().getLocalTransformation();
            if (newTransformation.equals(this.originalTransformation)) {
                PrintUtilities.println("Adding an undoable action for a manipulation that didn't actually change the transformation.");
            }
            Animator animator = this.dragAdapter != null ? this.dragAdapter.getAnimator() : null;
            PredeterminedSetLocalTransformationActionOperation undoOperation = new PredeterminedSetLocalTransformationActionOperation(Project.GROUP_UUID, false, animator, this.getManipulatedTransformable(), this.originalTransformation, newTransformation, this.getUndoRedoDescription());
            ZManager.performIfAppropriate(undoOperation, null, false);
        }
    }

    public boolean isUndoable() {
        return this.hasUpdated();
    }

    public abstract boolean doStartManipulator(InputState var1);

    public abstract void doDataUpdateManipulator(InputState var1, InputState var2);

    public abstract void doTimeUpdateManipulator(double var1, InputState var3);

    public abstract void doEndManipulator(InputState var1, InputState var2);
}

