/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.manipulator;

import edu.cmu.cs.dennisc.math.Vector2;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;
import java.awt.Color;
import org.alice.interact.MovementDirection;
import org.alice.interact.MovementType;
import org.alice.interact.condition.MovementDescription;
import org.alice.interact.event.ManipulationEvent;
import org.alice.interact.handle.ImageBasedManipulationHandle2D;
import org.alice.interact.manipulator.Camera2DDragManipulator;

public class CameraDragStrafeManipulator
extends Camera2DDragManipulator {
    protected static final Color UP = Color.RED;
    protected static final Color LEFT = Color.GREEN;
    protected static final Color RIGHT = Color.BLUE;
    protected static final Color DOWN = Color.WHITE;

    public CameraDragStrafeManipulator(ImageBasedManipulationHandle2D handle) {
        super(handle);
    }

    protected void initializeEventMessages() {
        this.manipulationEvents.clear();
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Translate, new MovementDescription(MovementDirection.UP, MovementType.STOOD_UP), this.manipulatedTransformable));
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Translate, new MovementDescription(MovementDirection.DOWN, MovementType.STOOD_UP), this.manipulatedTransformable));
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Translate, new MovementDescription(MovementDirection.LEFT, MovementType.STOOD_UP), this.manipulatedTransformable));
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Translate, new MovementDescription(MovementDirection.RIGHT, MovementType.STOOD_UP), this.manipulatedTransformable));
    }

    protected Vector3 getMovementVectorForColor(Color color) {
        Vector3 initialMove = new Vector3(0.0, 0.0, 0.0);
        if (color != null) {
            if (color.equals(UP)) {
                initialMove.y = 10.0;
            } else if (color.equals(DOWN)) {
                initialMove.y = -10.0;
            } else if (color.equals(LEFT)) {
                initialMove.x = -10.0;
            } else if (color.equals(RIGHT)) {
                initialMove.x = 10.0;
            }
        }
        return initialMove;
    }

    protected Vector3 getRotationVectorForColor(Color color) {
        return new Vector3(0.0, 0.0, 0.0);
    }

    protected Vector3 getRelativeMovementAmount(Vector2 mousePos, double time) {
        Vector2 relativeMousePos = Vector2.createSubtraction(mousePos, this.initialMousePosition);
        if (this.initialHandleColor != null) {
            if (this.initialHandleColor.equals(LEFT) || this.initialHandleColor.equals(RIGHT)) {
                relativeMousePos.y = Math.abs(relativeMousePos.y) < 10.0 ? 0.0 : (relativeMousePos.y < 0.0 ? (relativeMousePos.y += 10.0) : 10.0);
            } else if (this.initialHandleColor.equals(UP) || this.initialHandleColor.equals(DOWN)) {
                relativeMousePos.x = Math.abs(relativeMousePos.x) < 10.0 ? 0.0 : (relativeMousePos.x < 0.0 ? (relativeMousePos.x += 10.0) : 10.0);
            }
        }
        relativeMousePos.y *= -1.0;
        double amountToMoveY = relativeMousePos.y * 0.1 * time;
        double amountToMoveX = relativeMousePos.x * 0.1 * time;
        Vector3 amountToMoveMouse = new Vector3(amountToMoveX, amountToMoveY, 0.0);
        return amountToMoveMouse;
    }

    protected Vector3 getRelativeRotationAmount(Vector2 mousePos, double time) {
        return new Vector3(0.0, 0.0, 0.0);
    }

    protected ReferenceFrame getRotationReferenceFrame() {
        return this.standUpReference;
    }

    protected ReferenceFrame getMovementReferenceFrame() {
        return this.standUpReference;
    }
}

