/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.manipulator;

import edu.cmu.cs.dennisc.math.AngleInDegrees;
import edu.cmu.cs.dennisc.math.Plane;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.scenegraph.AsSeenBy;
import edu.cmu.cs.dennisc.scenegraph.StandIn;
import org.alice.interact.InputState;
import org.alice.interact.PlaneUtilities;
import org.alice.interact.manipulator.CameraManipulator;

public class CameraOrbitDragManipulator
extends CameraManipulator {
    Point3 pivotPoint = null;
    static final Plane GROUND_PLANE = new Plane(0.0, 1.0, 0.0, 0.0);
    static final double TURN_RATE = 2.0;

    public void setPivotPoint(Point3 pivotPoint) {
        this.pivotPoint = pivotPoint;
    }

    public String getUndoRedoDescription() {
        return "Camera Rotate";
    }

    public void doDataUpdateManipulator(InputState currentInput, InputState previousInput) {
        int xChange = currentInput.getMouseLocation().x - previousInput.getMouseLocation().x;
        int yChange = currentInput.getMouseLocation().y - previousInput.getMouseLocation().y;
        double leftRightRotationAngle = (double)xChange * 2.0;
        double upDownRotationAngle = (double)yChange * 2.0;
        StandIn standIn = new StandIn();
        standIn.vehicle.setValue(this.getCamera().getRoot());
        standIn.setTranslationOnly(this.pivotPoint, AsSeenBy.SCENE);
        standIn.setAxesOnlyToPointAt(this.getCamera());
        standIn.setAxesOnlyToStandUp();
        this.manipulatedTransformable.applyRotationAboutXAxis(new AngleInDegrees(upDownRotationAngle), standIn);
        this.manipulatedTransformable.applyRotationAboutYAxis(new AngleInDegrees(leftRightRotationAngle), standIn);
    }

    public void doEndManipulator(InputState endInput, InputState previousInput) {
    }

    public boolean doStartManipulator(InputState startInput) {
        if (super.doStartManipulator(startInput)) {
            Vector3 cameraForward = this.manipulatedTransformable.getAbsoluteTransformation().orientation.backward;
            cameraForward.multiply(-1.0);
            Point3 pickPoint = PlaneUtilities.getPointInPlane(GROUND_PLANE, new Ray(this.manipulatedTransformable.getAbsoluteTransformation().translation, cameraForward));
            if (pickPoint != null) {
                this.setPivotPoint(pickPoint);
                return true;
            }
        }
        return false;
    }

    public void doTimeUpdateManipulator(double time, InputState currentInput) {
    }
}

