/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.manipulator;

import edu.cmu.cs.dennisc.lookingglass.OnscreenLookingGlass;
import edu.cmu.cs.dennisc.math.Plane;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.Transformable;
import java.awt.Point;
import org.alice.interact.InputState;
import org.alice.interact.MovementDirection;
import org.alice.interact.PickHint;
import org.alice.interact.PlaneUtilities;
import org.alice.interact.VectorUtilities;
import org.alice.interact.condition.MovementDescription;
import org.alice.interact.event.ManipulationEvent;
import org.alice.interact.handle.HandleSet;
import org.alice.interact.handle.LinearDragHandle;
import org.alice.interact.manipulator.AbstractManipulator;
import org.alice.interact.manipulator.CameraInformedManipulator;

public class LinearDragManipulator
extends AbstractManipulator
implements CameraInformedManipulator {
    protected OnscreenLookingGlass onscreenLookingGlass = null;
    protected LinearDragHandle linearHandle;
    protected Vector3 absoluteDragAxis;
    protected Point3 initialClickPoint = new Point3();
    protected Point3 originalOrigin;
    protected Plane cameraFacingPlane;
    protected Plane handleAlignedPlane;

    public AbstractCamera getCamera() {
        if (this.onscreenLookingGlass != null) {
            return this.onscreenLookingGlass.getCameraAt(0);
        }
        return null;
    }

    public void setOnscreenLookingGlass(OnscreenLookingGlass onscreenLookingGlass) {
        this.onscreenLookingGlass = onscreenLookingGlass;
    }

    public String getUndoRedoDescription() {
        return "Object Move";
    }

    protected void initializeEventMessages() {
        this.manipulationEvents.clear();
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Translate, this.linearHandle.getMovementDescription(), this.manipulatedTransformable));
        MovementDirection oppositeDirection = this.linearHandle.getMovementDescription().direction.getOpposite();
        if (oppositeDirection != this.linearHandle.getMovementDescription().direction) {
            this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Translate, new MovementDescription(oppositeDirection, this.linearHandle.getMovementDescription().type), this.manipulatedTransformable));
        }
    }

    protected double getDistanceAlongAxisBasedOnMouse(Point mouseLocation) {
        Ray pickRay = PlaneUtilities.getRayFromPixel(this.onscreenLookingGlass, this.getCamera(), mouseLocation.x, mouseLocation.y);
        if (pickRay != null) {
            double axisCameraDot = Vector3.calculateDotProduct(this.absoluteDragAxis, this.getCamera().getAbsoluteTransformation().orientation.backward);
            if (Math.abs(axisCameraDot) > 0.98) {
                Point3 pointInPlane = PlaneUtilities.getPointInPlane(this.cameraFacingPlane, pickRay);
                Vector3 fromOriginalMouseToCurrentMouse = Vector3.createSubtraction(pointInPlane, this.initialClickPoint);
                Vector3 dragRightAxis = this.getCamera().getAbsoluteTransformation().orientation.right;
                dragRightAxis.normalize();
                Vector3 dragUpAxis = this.getCamera().getAbsoluteTransformation().orientation.up;
                dragUpAxis.normalize();
                double leftRightSign = 1.0;
                if (Vector3.calculateDotProduct(this.absoluteDragAxis, dragRightAxis) < 0.0) {
                    leftRightSign = -1.0;
                }
                double upDownSign = 1.0;
                if (Vector3.calculateDotProduct(this.absoluteDragAxis, dragUpAxis) < 0.0) {
                    upDownSign = -1.0;
                }
                double mouseYDistance = upDownSign * Vector3.calculateDotProduct(fromOriginalMouseToCurrentMouse, dragUpAxis);
                double mouseXDistance = leftRightSign * Vector3.calculateDotProduct(fromOriginalMouseToCurrentMouse, dragRightAxis);
                return this.linearHandle.getCurrentHandleLength() + mouseYDistance + mouseXDistance;
            }
            Point3 pointInPlane = PlaneUtilities.getPointInPlane(this.handleAlignedPlane, pickRay);
            if (pointInPlane != null) {
                Vector3 pointVector = Vector3.createSubtraction(pointInPlane, this.originalOrigin);
                double dragAmount = Vector3.calculateDotProduct(pointVector, this.absoluteDragAxis);
                return dragAmount;
            }
        }
        return 0.0;
    }

    protected void updateBasedOnHandlePull(double previousPull, double newPull) {
        Vector3 translation = Vector3.createMultiplication((Tuple3)this.linearHandle.getDragAxis(), newPull - previousPull);
        Vector3 movementDif = new Vector3(translation);
        movementDif.normalize();
        for (ManipulationEvent event : this.manipulationEvents) {
            double dot = Vector3.calculateDotProduct(event.getMovementDescription().direction.getVector(), movementDif);
            if (dot > 0.1) {
                this.dragAdapter.triggerManipulationEvent(event, true);
                continue;
            }
            if (!(dot < -0.07)) continue;
            this.dragAdapter.triggerManipulationEvent(event, false);
        }
        this.manipulatedTransformable.applyTranslation(translation, this.linearHandle.getReferenceFrame());
    }

    public void doDataUpdateManipulator(InputState currentInput, InputState previousInput) {
        if (!currentInput.getMouseLocation().equals(previousInput.getMouseLocation())) {
            double currentDistance = this.getDistanceAlongAxisBasedOnMouse(currentInput.getMouseLocation());
            double previousDistance = this.getDistanceAlongAxisBasedOnMouse(previousInput.getMouseLocation());
            this.updateBasedOnHandlePull(previousDistance, currentDistance);
        }
    }

    public void doEndManipulator(InputState endInput, InputState previousInput) {
    }

    public boolean doStartManipulator(InputState startInput) {
        Transformable clickedHandle = PickHint.HANDLES.getMatchingTransformable(startInput.getClickPickedTransformable(true));
        if (clickedHandle instanceof LinearDragHandle) {
            this.linearHandle = (LinearDragHandle)clickedHandle;
            this.manipulatedTransformable = this.linearHandle.getManipulatedObject();
            this.initializeEventMessages();
            this.absoluteDragAxis = this.linearHandle.getReferenceFrame().getAbsoluteTransformation().createTransformed(this.linearHandle.getDragAxis());
            startInput.getClickPickResult().getPositionInSource(this.initialClickPoint);
            startInput.getClickPickResult().getSource().transformTo_AffectReturnValuePassedIn(this.initialClickPoint, (Component)startInput.getClickPickResult().getSource().getRoot());
            Vector3 toCamera = Vector3.createSubtraction(this.getCamera().getAbsoluteTransformation().translation, this.manipulatedTransformable.getAbsoluteTransformation().translation);
            toCamera.normalize();
            Vector3 axisAlignedNormal = null;
            if (Math.abs(Vector3.calculateDotProduct(toCamera, this.absoluteDragAxis)) > 0.99) {
                axisAlignedNormal = toCamera;
            } else {
                Vector3 axisAlignedCameraVector = VectorUtilities.projectOntoVector(toCamera, this.absoluteDragAxis);
                Vector3 awayFromAxis = Vector3.createSubtraction(toCamera, axisAlignedCameraVector);
                awayFromAxis.normalize();
                axisAlignedNormal = awayFromAxis;
            }
            this.handleAlignedPlane = new Plane(this.linearHandle.getAbsoluteTransformation().translation, axisAlignedNormal);
            this.cameraFacingPlane = new Plane(this.initialClickPoint, this.getCamera().getAbsoluteTransformation().orientation.backward);
            this.originalOrigin = this.manipulatedTransformable.getAbsoluteTransformation().translation;
            return true;
        }
        return false;
    }

    public void doTimeUpdateManipulator(double time, InputState currentInput) {
    }

    protected HandleSet getHandleSetToEnable() {
        return new HandleSet(this.linearHandle.getMovementDescription().direction.getHandleGroup(), HandleSet.HandleGroup.VISUALIZATION, HandleSet.HandleGroup.TRANSLATION);
    }
}

