/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.manipulator;

import edu.cmu.cs.dennisc.awt.CursorUtilities;
import edu.cmu.cs.dennisc.lookingglass.LookingGlass;
import edu.cmu.cs.dennisc.lookingglass.OnscreenLookingGlass;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.AngleInRadians;
import edu.cmu.cs.dennisc.math.AngleUtilities;
import edu.cmu.cs.dennisc.math.Plane;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.Transformable;
import edu.cmu.cs.dennisc.scenegraph.util.TransformationUtilities;
import java.awt.AWTException;
import java.awt.Point;
import java.awt.Robot;
import javax.swing.SwingUtilities;
import org.alice.interact.InputState;
import org.alice.interact.PickHint;
import org.alice.interact.PlaneUtilities;
import org.alice.interact.VectorUtilities;
import org.alice.interact.handle.HandleSet;
import org.alice.interact.handle.RotationRingHandle;
import org.alice.interact.manipulator.AbstractManipulator;
import org.alice.interact.manipulator.CameraInformedManipulator;

public class ObjectRotateDragManipulator
extends AbstractManipulator
implements CameraInformedManipulator {
    protected static final double BAD_ANGLE_THRESHOLD = 0.2617993877991494;
    protected static final double WORLD_DISTANCE_TO_RADIANS_MULTIPLIER = 1.1;
    protected OnscreenLookingGlass onscreenLookingGlass = null;
    protected Point3 initialClickPoint = new Point3();
    protected Point3 objectOriginInPlane;
    protected Plane rotationPlane;
    protected Vector3 originalMouseDirection;
    protected Vector3 originalMouseRightDirection;
    protected Vector3 absoluteRotationAxis;
    protected Plane cameraFacingPlane;
    protected RotationRingHandle rotationHandle;

    public AbstractCamera getCamera() {
        if (this.onscreenLookingGlass != null) {
            return this.onscreenLookingGlass.getCameraAt(0);
        }
        return null;
    }

    public void setOnscreenLookingGlass(OnscreenLookingGlass onscreenLookingGlass) {
        this.onscreenLookingGlass = onscreenLookingGlass;
    }

    protected void initManipulator(RotationRingHandle handle, InputState startInput) {
        this.rotationHandle = handle;
        this.manipulatedTransformable = this.rotationHandle.getManipulatedObject();
        this.absoluteRotationAxis = this.rotationHandle.getReferenceFrame().getAbsoluteTransformation().createTransformed(this.rotationHandle.getRotationAxis());
        startInput.getClickPickResult().getPositionInSource(this.initialClickPoint);
        startInput.getClickPickResult().getSource().transformTo_AffectReturnValuePassedIn(this.initialClickPoint, (Component)startInput.getClickPickResult().getSource().getRoot());
        Vector3 rotationAxis = this.absoluteRotationAxis;
        this.rotationPlane = new Plane(this.initialClickPoint, rotationAxis);
        Ray originRay = new Ray(this.manipulatedTransformable.getAbsoluteTransformation().translation, rotationAxis);
        double intersection = this.rotationPlane.intersect(originRay);
        if (Double.isNaN(intersection)) {
            originRay = new Ray(this.manipulatedTransformable.getAbsoluteTransformation().translation, Vector3.createMultiplication((Tuple3)rotationAxis, -1.0));
            intersection = this.rotationPlane.intersect(originRay);
        }
        if (!Double.isNaN(intersection)) {
            this.objectOriginInPlane = originRay.getPointAlong(intersection);
            Vector3 toMouse = Vector3.createSubtraction(this.initialClickPoint, this.objectOriginInPlane);
            toMouse.normalize();
            this.originalMouseDirection = new Vector3(toMouse);
            this.originalMouseRightDirection = Vector3.createCrossProduct(this.originalMouseDirection, rotationAxis);
            this.rotationHandle.setSphereVisibility(true);
            Vector3 sphereDirection = TransformationUtilities.transformFromAbsolute_New(toMouse, (Component)this.rotationHandle);
            this.rotationHandle.setSphereDirection(sphereDirection);
            this.hideCursor();
        }
        this.cameraFacingPlane = new Plane(this.initialClickPoint, this.getCamera().getAbsoluteTransformation().orientation.backward);
    }

    public boolean doStartManipulator(InputState startInput) {
        Transformable clickedHandle = PickHint.HANDLES.getMatchingTransformable(startInput.getClickPickedTransformable(true));
        if (clickedHandle instanceof RotationRingHandle) {
            this.initManipulator((RotationRingHandle)clickedHandle, startInput);
            return true;
        }
        return false;
    }

    protected Angle getRotationBasedOnMouse(Point mouseLocation) {
        Ray pickRay = PlaneUtilities.getRayFromPixel(this.onscreenLookingGlass, this.getCamera(), mouseLocation.x, mouseLocation.y);
        if (pickRay != null) {
            AngleInRadians angleBetweenVector = VectorUtilities.getAngleBetweenVectors(this.absoluteRotationAxis, this.getCamera().getAbsoluteTransformation().orientation.backward);
            double distanceToRightAngle = Math.abs(1.5707963267948966 - angleBetweenVector.getAsRadians());
            if (distanceToRightAngle < 0.2617993877991494) {
                Point3 pointInPlane = PlaneUtilities.getPointInPlane(this.cameraFacingPlane, pickRay);
                Vector3 fromOriginalMouseToCurrentMouse = Vector3.createSubtraction(pointInPlane, this.initialClickPoint);
                Vector3 rotationRightAxis = Vector3.createCrossProduct(this.absoluteRotationAxis, this.getCamera().getAbsoluteTransformation().orientation.backward);
                double mouseDistance = Vector3.calculateDotProduct(fromOriginalMouseToCurrentMouse, rotationRightAxis);
                return new AngleInRadians(mouseDistance * 1.1);
            }
            Point3 pointInPlane = PlaneUtilities.getPointInPlane(this.rotationPlane, pickRay);
            if (pointInPlane != null) {
                Vector3 toMouse = Vector3.createSubtraction(pointInPlane, this.objectOriginInPlane);
                double toMouseDotOriginalRight = Vector3.calculateDotProduct(toMouse, this.originalMouseRightDirection);
                boolean isToTheRight = toMouseDotOriginalRight > 0.0;
                toMouse.normalize();
                Vector3 toMouseDirection = new Vector3(toMouse);
                double cosOfAngleBetween = Vector3.calculateDotProduct(this.originalMouseDirection, toMouseDirection);
                if (cosOfAngleBetween > 1.0) {
                    cosOfAngleBetween = 1.0;
                } else if (cosOfAngleBetween < -1.0) {
                    cosOfAngleBetween = -1.0;
                }
                double angleInRadians = Math.acos(cosOfAngleBetween);
                if (isToTheRight) {
                    angleInRadians = Math.PI * 2 - angleInRadians;
                }
                return new AngleInRadians(angleInRadians);
            }
        }
        return null;
    }

    public void doDataUpdateManipulator(InputState currentInput, InputState previousInput) {
        if (!currentInput.getMouseLocation().equals(previousInput.getMouseLocation())) {
            Angle currentAngle = this.getRotationBasedOnMouse(currentInput.getMouseLocation());
            Angle previousAngle = this.getRotationBasedOnMouse(previousInput.getMouseLocation());
            if (currentAngle != null && previousAngle != null) {
                Angle angleDif = AngleUtilities.createSubtraction(currentAngle, previousAngle);
                this.manipulatedTransformable.applyRotationAboutArbitraryAxis(this.rotationHandle.getRotationAxis(), angleDif, this.rotationHandle.getReferenceFrame());
            }
        }
    }

    public void doTimeUpdateManipulator(double time, InputState currentInput) {
    }

    protected void hideCursor() {
        CursorUtilities.pushAndSet(this.onscreenLookingGlass.getAWTComponent(), CursorUtilities.NULL_CURSOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showCursor() {
        try {
            Point3 pointInCamera = this.rotationHandle.getSphereLocation(this.getCamera());
            Point awtPoint = edu.cmu.cs.dennisc.lookingglass.util.TransformationUtilities.transformFromCameraToAWT_New(pointInCamera, (LookingGlass)this.onscreenLookingGlass, this.getCamera());
            SwingUtilities.convertPointToScreen(awtPoint, this.onscreenLookingGlass.getAWTComponent());
            Robot mouseMover = new Robot();
            mouseMover.mouseMove(awtPoint.x, awtPoint.y);
        }
        catch (AWTException aWTException) {
        }
        finally {
            CursorUtilities.popAndSet(this.onscreenLookingGlass.getAWTComponent());
        }
    }

    public String getUndoRedoDescription() {
        return "Object Rotate";
    }

    public void doEndManipulator(InputState endInput, InputState previousInput) {
        this.rotationHandle.setSphereVisibility(false);
        this.showCursor();
    }

    protected HandleSet getHandleSetToEnable() {
        return new HandleSet(this.rotationHandle.getRotationDirection().getHandleGroup(), HandleSet.HandleGroup.VISUALIZATION, HandleSet.HandleGroup.ROTATION);
    }
}

