/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.manipulator;

import edu.cmu.cs.dennisc.lookingglass.OnscreenLookingGlass;
import edu.cmu.cs.dennisc.math.AngleInRadians;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import edu.cmu.cs.dennisc.math.Plane;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.scenegraph.AsSeenBy;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;
import java.awt.Point;
import org.alice.interact.InputState;
import org.alice.interact.MovementDirection;
import org.alice.interact.MovementType;
import org.alice.interact.PlaneUtilities;
import org.alice.interact.VectorUtilities;
import org.alice.interact.condition.MovementDescription;
import org.alice.interact.event.ManipulationEvent;
import org.alice.interact.handle.HandleSet;
import org.alice.interact.manipulator.AbstractManipulator;
import org.alice.interact.manipulator.CameraInformedManipulator;

public class ObjectTranslateDragManipulator
extends AbstractManipulator
implements CameraInformedManipulator {
    protected static final double BAD_ANGLE_THRESHOLD = 0.13962634015954636;
    protected static final double MIN_BAD_ANGLE_THRESHOLD = 0.0;
    protected OnscreenLookingGlass onscreenLookingGlass = null;
    protected Point3 initialClickPoint = new Point3();
    protected Point3 initialObjectPosition = new Point3();
    protected Plane movementPlane = new Plane(0.0, 1.0, 0.0, 0.0);
    protected Plane badAnglePlane = null;
    protected Point3 offsetToOrigin = null;
    protected Point initialMouseLocation = new Point();
    protected Boolean hasMoved = false;

    public AbstractCamera getCamera() {
        if (this.onscreenLookingGlass != null) {
            return this.onscreenLookingGlass.getCameraAt(0);
        }
        return null;
    }

    public void setOnscreenLookingGlass(OnscreenLookingGlass onscreenLookingGlass) {
        this.onscreenLookingGlass = onscreenLookingGlass;
    }

    public String getUndoRedoDescription() {
        return "Object Move";
    }

    protected void initializeEventMessages() {
        this.manipulationEvents.clear();
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Translate, new MovementDescription(MovementDirection.LEFT, MovementType.ABSOLUTE), this.manipulatedTransformable));
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Translate, new MovementDescription(MovementDirection.RIGHT, MovementType.ABSOLUTE), this.manipulatedTransformable));
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Translate, new MovementDescription(MovementDirection.FORWARD, MovementType.ABSOLUTE), this.manipulatedTransformable));
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Translate, new MovementDescription(MovementDirection.BACKWARD, MovementType.ABSOLUTE), this.manipulatedTransformable));
    }

    protected Point3 getPositionForPlane(Plane movementPlane, Ray pickRay) {
        if (pickRay != null) {
            Point3 pointInPlane = PlaneUtilities.getPointInPlane(movementPlane, pickRay);
            Point3 newPosition = Point3.createAddition(this.offsetToOrigin, pointInPlane);
            newPosition.y = this.initialObjectPosition.y;
            return newPosition;
        }
        return null;
    }

    protected Point3 getPositionBasedonOnMouseLocation(Point mouseLocation) {
        Ray pickRay = PlaneUtilities.getRayFromPixel(this.onscreenLookingGlass, this.getCamera(), mouseLocation.x, mouseLocation.y);
        if (pickRay != null) {
            Plane toMoveIn = this.movementPlane;
            double badAngleAmount = this.getBadAngleAmount(this.movementPlane, pickRay);
            if (badAngleAmount > 0.0) {
                Vector3 newNormal = Vector3.createInterpolation(PlaneUtilities.getPlaneNormal(this.movementPlane), PlaneUtilities.getPlaneNormal(this.badAnglePlane), badAngleAmount);
                newNormal.normalize();
                toMoveIn = new Plane(this.initialClickPoint, newNormal);
            }
            Point3 newPosition = this.getPositionForPlane(toMoveIn, pickRay);
            return newPosition;
        }
        return null;
    }

    protected double getBadAngleAmount(Plane plane, Ray pickRay) {
        Vector3 cameraDirection = this.getCamera().getAbsoluteTransformation().orientation.backward;
        double cameraDistanceFactor = Math.abs(PlaneUtilities.distanceToPlane(plane, this.getCamera().getAbsoluteTransformation().translation));
        Vector3 planeNormal = PlaneUtilities.getPlaneNormal(plane);
        AngleInRadians angleBetweenVector = VectorUtilities.getAngleBetweenVectors(cameraDirection, planeNormal);
        double distanceToRightAngle = Math.abs(1.5707963267948966 - angleBetweenVector.getAsRadians());
        double scaledBadAngleThreshold = 0.13962634015954636 / cameraDistanceFactor;
        double scaledMinBadAngleThreshold = 0.0 / cameraDistanceFactor;
        if (distanceToRightAngle < scaledBadAngleThreshold) {
            if (distanceToRightAngle < scaledMinBadAngleThreshold) {
                return 1.0;
            }
            double thresholdDif = scaledBadAngleThreshold - scaledMinBadAngleThreshold;
            return (thresholdDif - (distanceToRightAngle -= scaledMinBadAngleThreshold)) / thresholdDif;
        }
        return 0.0;
    }

    protected Plane createCameraFacingStoodUpPlane(Point3 clickPoint) {
        return new Plane(clickPoint, this.createCameraFacingStoodUpVector());
    }

    protected Vector3 createCameraFacingStoodUpVector() {
        Vector3 cameraBackward = this.getCamera().getAxes((ReferenceFrame)AsSeenBy.SCENE).backward;
        if (EpsilonUtilities.isWithinReasonableEpsilon((Number)cameraBackward.y, 1.0)) {
            return Vector3.createMultiplication((Tuple3)this.getCamera().getAbsoluteTransformation().orientation.up, -1.0);
        }
        cameraBackward.y = 0.0;
        cameraBackward.normalize();
        return cameraBackward;
    }

    protected Plane createBadAnglePlane(Point3 clickPoint) {
        Vector3 badPlaneNormal = this.createCameraFacingStoodUpVector();
        badPlaneNormal.y += 2.0;
        badPlaneNormal.normalize();
        return new Plane(clickPoint, badPlaneNormal);
    }

    protected Plane createPickPlane(Point3 clickPoint) {
        return new Plane(clickPoint, Vector3.createPositiveYAxis());
    }

    public void doDataUpdateManipulator(InputState currentInput, InputState previousInput) {
        if (!currentInput.getMouseLocation().equals(previousInput.getMouseLocation()) && this.manipulatedTransformable != null) {
            if (!this.hasMoved.booleanValue()) {
                this.hasMoved = true;
            }
            Point3 newPosition = this.getPositionBasedonOnMouseLocation(currentInput.getMouseLocation());
            Vector3 movementDif = Vector3.createSubtraction(newPosition, this.manipulatedTransformable.getAbsoluteTransformation().translation);
            movementDif.normalize();
            for (ManipulationEvent event : this.manipulationEvents) {
                double dot = Vector3.calculateDotProduct(event.getMovementDescription().direction.getVector(), movementDif);
                if (dot > 0.1) {
                    this.dragAdapter.triggerManipulationEvent(event, true);
                    continue;
                }
                if (!(dot < -0.07)) continue;
                this.dragAdapter.triggerManipulationEvent(event, false);
            }
            if (newPosition != null) {
                this.manipulatedTransformable.setTranslationOnly(newPosition, AsSeenBy.SCENE);
            }
        }
    }

    public void doEndManipulator(InputState endInput, InputState previousInput) {
    }

    public boolean doStartManipulator(InputState startInput) {
        this.manipulatedTransformable = startInput.getClickPickTransformable();
        if (this.manipulatedTransformable != null) {
            this.initializeEventMessages();
            this.initialMouseLocation.setLocation(startInput.getMouseLocation());
            this.hasMoved = false;
            this.initialObjectPosition.set(this.manipulatedTransformable.getAbsoluteTransformation().translation);
            startInput.getClickPickResult().getPositionInSource(this.initialClickPoint);
            startInput.getClickPickResult().getSource().transformTo_AffectReturnValuePassedIn(this.initialClickPoint, (Component)startInput.getClickPickResult().getSource().getRoot());
            this.movementPlane = this.createPickPlane(this.initialClickPoint);
            this.badAnglePlane = this.createBadAnglePlane(this.initialClickPoint);
            Ray pickRay = PlaneUtilities.getRayFromPixel(this.onscreenLookingGlass, this.getCamera(), startInput.getMouseLocation().x, startInput.getMouseLocation().y);
            if (pickRay != null) {
                this.initialClickPoint = PlaneUtilities.getPointInPlane(this.movementPlane, pickRay);
                this.offsetToOrigin = Point3.createSubtraction(this.manipulatedTransformable.getAbsoluteTransformation().translation, this.initialClickPoint);
                this.movementPlane = this.createPickPlane(this.initialClickPoint);
                this.badAnglePlane = this.createBadAnglePlane(this.initialClickPoint);
            } else {
                this.manipulatedTransformable = null;
            }
            if (this.manipulatedTransformable != null) {
                return true;
            }
        }
        return false;
    }

    public void doTimeUpdateManipulator(double time, InputState currentInput) {
    }

    protected HandleSet getHandleSetToEnable() {
        return HandleSet.GROUND_TRANSLATION_VISUALIZATION;
    }
}

