/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.manipulator;

import edu.cmu.cs.dennisc.math.Plane;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.math.Vector3;
import org.alice.interact.MovementDirection;
import org.alice.interact.MovementType;
import org.alice.interact.PlaneUtilities;
import org.alice.interact.condition.MovementDescription;
import org.alice.interact.event.ManipulationEvent;
import org.alice.interact.handle.HandleSet;
import org.alice.interact.manipulator.ObjectTranslateDragManipulator;

public class ObjectUpDownDragManipulator
extends ObjectTranslateDragManipulator {
    protected void initializeEventMessages() {
        this.manipulationEvents.clear();
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Translate, new MovementDescription(MovementDirection.UP, MovementType.ABSOLUTE), this.manipulatedTransformable));
        this.manipulationEvents.add(new ManipulationEvent(ManipulationEvent.EventType.Translate, new MovementDescription(MovementDirection.DOWN, MovementType.ABSOLUTE), this.manipulatedTransformable));
    }

    protected Plane createPickPlane(Point3 clickPoint) {
        return this.createCameraFacingStoodUpPlane(clickPoint);
    }

    protected Plane createBadAnglePlane(Point3 clickPoint) {
        Vector3 cameraUp = this.getCamera().getAbsoluteTransformation().orientation.up;
        Vector3 badPlaneNormal = Vector3.createPositiveYAxis();
        badPlaneNormal.subtract(cameraUp);
        badPlaneNormal.normalize();
        return new Plane(clickPoint, badPlaneNormal);
    }

    protected Point3 getPositionForPlane(Plane movementPlane, Ray pickRay) {
        if (pickRay != null) {
            Point3 pointInPlane = PlaneUtilities.getPointInPlane(movementPlane, pickRay);
            Point3 newPosition = Point3.createAddition(this.offsetToOrigin, pointInPlane);
            newPosition.x = this.initialObjectPosition.x;
            newPosition.z = this.initialObjectPosition.z;
            return newPosition;
        }
        return null;
    }

    protected HandleSet getHandleSetToEnable() {
        return new HandleSet(HandleSet.HandleGroup.Y_AXIS, HandleSet.HandleGroup.VISUALIZATION, HandleSet.HandleGroup.TRANSLATION);
    }
}

