/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.manipulator;

import edu.cmu.cs.dennisc.math.AxisAlignedBox;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.scenegraph.AsSeenBy;
import org.alice.interact.InputState;
import org.alice.interact.MovementKey;
import org.alice.interact.MovementType;
import org.alice.interact.handle.HandleSet;
import org.alice.interact.manipulator.AbstractManipulator;

public class TranslateKeyManipulator
extends AbstractManipulator {
    protected static double MOVEMENT_RATE = 5.0;
    protected static double CLICK_TIME = 0.1;
    protected static double CLICK_MOVE_AMOUNT = 0.2;
    protected Point3 initialPoint = new Point3();
    protected double startTime = 0.0;
    MovementKey[] directionKeys;
    protected AxisAlignedBox bounds;

    public TranslateKeyManipulator() {
        this.directionKeys = new MovementKey[0];
    }

    public TranslateKeyManipulator(MovementKey[] directionKeys) {
        this.setKeys(directionKeys);
    }

    public String getUndoRedoDescription() {
        return "Object Move";
    }

    public void setBounds(AxisAlignedBox bounds) {
        this.bounds = bounds;
    }

    public void setKeys(MovementKey[] directionKeys) {
        this.directionKeys = directionKeys;
    }

    public void addKeys(MovementKey[] directionKeys) {
        if (this.directionKeys != null && directionKeys != null) {
            int i;
            MovementKey[] combinedKeys = new MovementKey[this.directionKeys.length + directionKeys.length];
            for (i = 0; i < this.directionKeys.length; ++i) {
                combinedKeys[i] = this.directionKeys[i];
            }
            for (i = 0; i < directionKeys.length; ++i) {
                combinedKeys[this.directionKeys.length + i] = directionKeys[i];
            }
            this.setKeys(combinedKeys);
        } else {
            this.setKeys(directionKeys);
        }
    }

    protected Point3[] getMoveDirection(InputState input) {
        int i;
        MovementType[] movementTypes = MovementType.values();
        Point3[] moveDirs = new Point3[movementTypes.length];
        for (i = 0; i < moveDirs.length; ++i) {
            moveDirs[i] = new Point3(0.0, 0.0, 0.0);
        }
        for (i = 0; i < this.directionKeys.length; ++i) {
            if (!input.isKeyDown(this.directionKeys[i].keyValue)) continue;
            Point3 multipliedPoint = Point3.createMultiplication((Tuple3)this.directionKeys[i].movementDescription.direction.getVector(), this.directionKeys[i].directionMultiplier);
            moveDirs[this.directionKeys[i].movementDescription.type.getIndex()].add(multipliedPoint);
        }
        return moveDirs;
    }

    private void moveTransformable(Point3[] movementAmounts) {
        for (int i = 0; i < movementAmounts.length; ++i) {
            MovementType movementType;
            if (movementAmounts[i].x == 0.0 && movementAmounts[i].y == 0.0 && movementAmounts[i].z == 0.0 || (movementType = MovementType.getMovementTypeForIndex(i)) == null) continue;
            movementType.applyTranslation(this.manipulatedTransformable, movementAmounts[i]);
            if (this.bounds == null) continue;
            Point3 currentPos = this.manipulatedTransformable.getTranslation(AsSeenBy.SCENE);
            if (currentPos.x > this.bounds.getXMaximum()) {
                currentPos.x = this.bounds.getXMaximum();
            }
            if (currentPos.x < this.bounds.getXMinimum()) {
                currentPos.x = this.bounds.getXMinimum();
            }
            if (currentPos.y > this.bounds.getYMaximum()) {
                currentPos.y = this.bounds.getYMaximum();
            }
            if (currentPos.y < this.bounds.getYMinimum()) {
                currentPos.y = this.bounds.getYMinimum();
            }
            if (currentPos.z > this.bounds.getZMaximum()) {
                currentPos.z = this.bounds.getZMaximum();
            }
            if (currentPos.z < this.bounds.getZMinimum()) {
                currentPos.z = this.bounds.getZMinimum();
            }
            this.manipulatedTransformable.setTranslationOnly(currentPos, AsSeenBy.SCENE);
        }
    }

    public void doEndManipulator(InputState endInput, InputState previousInput) {
        Point3 positionDif;
        double distanceAlreadyMoved;
        double distanceToMove;
        double currentTime = (double)System.currentTimeMillis() * 0.001;
        if (currentTime - this.startTime < CLICK_TIME && (distanceToMove = CLICK_TIME * MOVEMENT_RATE) > (distanceAlreadyMoved = (positionDif = Point3.createSubtraction(this.manipulatedTransformable.getAbsoluteTransformation().translation, this.initialPoint)).calculateMagnitude())) {
            Point3[] translateDirections;
            for (Point3 direction : translateDirections = this.getMoveDirection(previousInput)) {
                direction.multiply(distanceToMove);
            }
            this.manipulatedTransformable.setTranslationOnly(this.initialPoint, this.manipulatedTransformable.getRoot());
            this.moveTransformable(translateDirections);
        }
    }

    public boolean doStartManipulator(InputState startInput) {
        if (this.manipulatedTransformable != null) {
            this.startTime = (double)System.currentTimeMillis() * 0.001;
            this.initialPoint.set(this.manipulatedTransformable.getAbsoluteTransformation().translation);
            return true;
        }
        return false;
    }

    public void doDataUpdateManipulator(InputState currentInput, InputState previousInput) {
    }

    public void doTimeUpdateManipulator(double dTime, InputState currentInput) {
        if (this.manipulatedTransformable != null) {
            Point3[] translateDirections;
            for (Point3 direction : translateDirections = this.getMoveDirection(currentInput)) {
                direction.multiply(MOVEMENT_RATE * dTime);
            }
            this.moveTransformable(translateDirections);
        }
    }

    protected HandleSet getHandleSetToEnable() {
        return null;
    }
}

