/*
 * Decompiled with CFR 0.152.
 */
package org.alice.interact.operations;

import edu.cmu.cs.dennisc.animation.Animator;
import edu.cmu.cs.dennisc.animation.Style;
import edu.cmu.cs.dennisc.animation.TraditionalStyle;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.math.animation.Vector3Animation;
import edu.cmu.cs.dennisc.pattern.Criterion;
import edu.cmu.cs.dennisc.scenegraph.AbstractTransformable;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.scale.ScaleUtilities;
import edu.cmu.cs.dennisc.zoot.AbstractActionOperation;
import edu.cmu.cs.dennisc.zoot.AbstractEdit;
import edu.cmu.cs.dennisc.zoot.ActionContext;
import java.util.Locale;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredeterminedScaleActionOperation
extends AbstractActionOperation {
    private boolean isDoRequired;
    private Animator animator;
    private AbstractTransformable sgTransformable;
    private Vector3 redoVector;
    private Vector3 undoVector;
    private Criterion<Component> criterion;
    private String editPresentationKey;

    public PredeterminedScaleActionOperation(UUID groupUUID, boolean isDoRequired, Animator animator, AbstractTransformable sgTransformable, Vector3 axis, Criterion<Component> criterion, String editPresentationKey) {
        super(groupUUID);
        this.isDoRequired = isDoRequired;
        this.animator = animator;
        this.sgTransformable = sgTransformable;
        assert (!axis.isNaN());
        assert (axis.x != 0.0);
        assert (axis.y != 0.0);
        assert (axis.z != 0.0);
        this.redoVector = axis;
        this.undoVector = new Vector3(1.0 / axis.x, 1.0 / axis.y, 1.0 / axis.z);
        assert (!this.undoVector.isNaN());
        this.criterion = criterion;
        this.editPresentationKey = editPresentationKey;
    }

    private void scale(final Vector3 axis) {
        if (this.animator != null) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class ScaleAnimation
            extends Vector3Animation {
                private Vector3 m_vPrev;
                private Vector3 m_vBuffer;

                public ScaleAnimation() {
                    super(0.5, (Style)TraditionalStyle.BEGIN_AND_END_GENTLY, new Vector3(1.0, 1.0, 1.0), vector3);
                    this.m_vPrev = new Vector3(1.0, 1.0, 1.0);
                    this.m_vBuffer = new Vector3();
                }

                @Override
                protected void updateValue(Vector3 v) {
                    Vector3.setReturnValueToDivision((Tuple3)this.m_vBuffer, (Tuple3)v, this.m_vPrev);
                    ScaleUtilities.applyScale(PredeterminedScaleActionOperation.this.sgTransformable, this.m_vBuffer, PredeterminedScaleActionOperation.this.criterion);
                    this.m_vPrev.set(v);
                }
            }
            this.animator.invokeLater(new ScaleAnimation(), null);
        } else {
            ScaleUtilities.applyScale(this.sgTransformable, axis, this.criterion);
        }
    }

    @Override
    public void perform(ActionContext actionContext) {
        actionContext.commitAndInvokeDo(new AbstractEdit(){

            public void doOrRedo(boolean isDo) {
                if (!isDo || PredeterminedScaleActionOperation.this.isDoRequired) {
                    PredeterminedScaleActionOperation.this.scale(PredeterminedScaleActionOperation.this.redoVector);
                }
            }

            public void undo() {
                PredeterminedScaleActionOperation.this.scale(PredeterminedScaleActionOperation.this.undoVector);
            }

            protected StringBuffer updatePresentation(StringBuffer rv, Locale locale) {
                rv.append(PredeterminedScaleActionOperation.this.editPresentationKey);
                return rv;
            }
        });
    }
}

