/*
 * Decompiled with CFR 0.152.
 */
package org.alice.virtualmachine;

import edu.cmu.cs.dennisc.equivalence.EquivalenceUtilities;
import edu.cmu.cs.dennisc.io.InputStreamUtilities;
import edu.cmu.cs.dennisc.pattern.NameChangeListenable;
import edu.cmu.cs.dennisc.pattern.Nameable;
import edu.cmu.cs.dennisc.pattern.event.NameEvent;
import edu.cmu.cs.dennisc.pattern.event.NameListener;
import edu.cmu.cs.dennisc.util.CollectionUtilities;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.alice.virtualmachine.event.ResourceContentEvent;
import org.alice.virtualmachine.event.ResourceContentListener;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Resource
implements Nameable,
NameChangeListenable {
    private UUID uuid;
    private String name;
    private String originalFileName;
    private String contentType;
    private byte[] data;
    private List<NameListener> nameListeners = new LinkedList<NameListener>();
    private List<ResourceContentListener> contentListeners = new LinkedList<ResourceContentListener>();
    private static String XML_NAME_ATTRIBUTE = "name";
    private static String XML_ORIGINAL_FILE_NAME_ATTRIBUTE = "originalFileName";
    private static String XML_CONTENT_TYPE_ATTRIBUTE = "contentType";

    protected Resource(UUID uuid) {
        this.uuid = uuid;
    }

    protected Resource(Class<?> cls, String resourceName, String contentType) {
        this.uuid = null;
        try {
            byte[] data = InputStreamUtilities.getBytes(cls, resourceName);
            this.setOriginalFileName(resourceName);
            this.setName(resourceName);
            this.setContent(contentType, data);
        }
        catch (IOException ioe) {
            throw new RuntimeException(resourceName, ioe);
        }
    }

    protected Resource(File file, String contentType) throws IOException {
        this.uuid = UUID.randomUUID();
        String resourceName = file.getName();
        byte[] data = InputStreamUtilities.getBytes(file);
        this.setOriginalFileName(resourceName);
        this.setName(resourceName);
        this.setContent(contentType, data);
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String name) {
        if (EquivalenceUtilities.areNotEquivalent(this.name, name)) {
            List<NameListener> list = this.nameListeners;
            synchronized (list) {
                NameEvent nameEvent = new NameEvent(this, name);
                for (NameListener nameListener : this.nameListeners) {
                    nameListener.nameChanging(nameEvent);
                }
                this.name = name;
                for (NameListener nameListener : this.nameListeners) {
                    nameListener.nameChanged(nameEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNameListener(NameListener nameListener) {
        assert (nameListener != null);
        List<NameListener> list = this.nameListeners;
        synchronized (list) {
            this.nameListeners.add(nameListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNameListener(NameListener nameListener) {
        assert (nameListener != null);
        List<NameListener> list = this.nameListeners;
        synchronized (list) {
            this.nameListeners.remove(nameListener);
        }
    }

    @Override
    public Iterable<NameListener> getNameListeners() {
        return this.nameListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContentListener(ResourceContentListener contentListener) {
        assert (contentListener != null);
        List<ResourceContentListener> list = this.contentListeners;
        synchronized (list) {
            this.contentListeners.add(contentListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContentListener(ResourceContentListener contentListener) {
        assert (contentListener != null);
        List<ResourceContentListener> list = this.contentListeners;
        synchronized (list) {
            this.contentListeners.remove(contentListener);
        }
    }

    public Iterable<ResourceContentListener> getContentListeners() {
        return this.contentListeners;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(String contentType, byte[] data) {
        List<ResourceContentListener> list = this.contentListeners;
        synchronized (list) {
            ResourceContentListener[] array = CollectionUtilities.createArray(this.contentListeners, ResourceContentListener.class);
            ResourceContentEvent e = new ResourceContentEvent(this, contentType, data);
            for (ResourceContentListener contentListener : array) {
                contentListener.contentChanging(e);
            }
            this.contentType = contentType;
            this.data = data;
            for (ResourceContentListener contentListener : array) {
                contentListener.contentChanged(e);
            }
        }
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public void setOriginalFileName(String originalFileName) {
        this.originalFileName = originalFileName;
    }

    public void decodeAttributes(Element xmlElement, byte[] data) {
        this.setName(xmlElement.getAttribute(XML_NAME_ATTRIBUTE));
        this.setOriginalFileName(xmlElement.getAttribute(XML_ORIGINAL_FILE_NAME_ATTRIBUTE));
        this.setContent(xmlElement.getAttribute(XML_CONTENT_TYPE_ATTRIBUTE), data);
    }

    public void encodeAttributes(Element xmlElement) {
        xmlElement.setAttribute(XML_NAME_ATTRIBUTE, this.getName());
        xmlElement.setAttribute(XML_ORIGINAL_FILE_NAME_ATTRIBUTE, this.getOriginalFileName());
        xmlElement.setAttribute(XML_CONTENT_TYPE_ATTRIBUTE, this.getContentType());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(Resource.class.getName());
        sb.append("[name=");
        sb.append(this.getName());
        sb.append(";contentType=");
        sb.append(this.getContentType());
        sb.append(";uuid=");
        sb.append(this.getUUID());
        sb.append("]");
        return sb.toString();
    }
}

