/*
 * Decompiled with CFR 0.152.
 */
package org.alice.virtualmachine.resources;

import edu.cmu.cs.dennisc.io.FileUtilities;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.alice.virtualmachine.Resource;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageResource
extends Resource {
    private static Map<String, String> extensionToContentTypeMap = new HashMap<String, String>();
    private static final String PNG_MIME_TYPE = "image/png";
    private static final String JPEG_MIME_TYPE = "image/jpeg";
    private static final String BMP_MIME_TYPE = "image/bmp";
    private static final String GIF_MIME_TYPE = "image/gif";
    private static Map<UUID, ImageResource> uuidToResourceMap;
    private int width = -1;
    private int height = -1;
    private static String XML_WIDTH_ATTRIBUTE;
    private static String XML_HEIGHT_ATTRIBUTE;

    public static String getContentType(String path) {
        String extension = FileUtilities.getExtension(path);
        return extensionToContentTypeMap.get(extension.toLowerCase());
    }

    public static String getContentType(File file) {
        return ImageResource.getContentType(file.getName());
    }

    public static boolean isAcceptableContentType(String contentType) {
        return extensionToContentTypeMap.containsValue(contentType);
    }

    public static FilenameFilter createFilenameFilter(final boolean areDirectoriesAccepted) {
        return new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File file = new File(dir, name);
                if (file.isDirectory()) {
                    return areDirectoriesAccepted;
                }
                return ImageResource.getContentType(name) != null;
            }
        };
    }

    private static ImageResource get(UUID uuid) {
        ImageResource rv = uuidToResourceMap.get(uuid);
        if (rv == null) {
            rv = new ImageResource(uuid);
            uuidToResourceMap.put(uuid, rv);
        }
        return rv;
    }

    public static ImageResource valueOf(String s) {
        return ImageResource.get(UUID.fromString(s));
    }

    public ImageResource(UUID uuid) {
        super(uuid);
    }

    public ImageResource(Class<?> cls, String resourceName, String contentType) {
        super(cls, resourceName, contentType);
    }

    public ImageResource(Class<?> cls, String resourceName) {
        this(cls, resourceName, ImageResource.getContentType(resourceName));
    }

    public ImageResource(File file, String contentType) throws IOException {
        super(file, contentType);
    }

    public ImageResource(File file) throws IOException {
        this(file, ImageResource.getContentType(file));
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public void encodeAttributes(Element xmlElement) {
        super.encodeAttributes(xmlElement);
        xmlElement.setAttribute(XML_WIDTH_ATTRIBUTE, Integer.toString(this.width));
        xmlElement.setAttribute(XML_HEIGHT_ATTRIBUTE, Integer.toString(this.height));
    }

    @Override
    public void decodeAttributes(Element xmlElement, byte[] data) {
        super.decodeAttributes(xmlElement, data);
        this.width = Integer.parseInt(xmlElement.getAttribute(XML_WIDTH_ATTRIBUTE));
        this.height = Integer.parseInt(xmlElement.getAttribute(XML_HEIGHT_ATTRIBUTE));
    }

    static {
        extensionToContentTypeMap.put("png", PNG_MIME_TYPE);
        extensionToContentTypeMap.put("jpg", JPEG_MIME_TYPE);
        extensionToContentTypeMap.put("jpeg", JPEG_MIME_TYPE);
        extensionToContentTypeMap.put("bmp", BMP_MIME_TYPE);
        extensionToContentTypeMap.put("gif", GIF_MIME_TYPE);
        uuidToResourceMap = new HashMap<UUID, ImageResource>();
        XML_WIDTH_ATTRIBUTE = "width";
        XML_HEIGHT_ATTRIBUTE = "height";
    }
}

