/* Copyright 2010, Joseph Bergin. All rights reserved.
 * License: Creative Commons Attribution-Noncommercial-Share Alike 3.0 United States License
 */

package alice.kareluser;

import java.awt.Dimension;

import org.alice.apis.moveandturn.Program;

import alice.kareltherobot.KarelWorld;

import edu.cmu.cs.dennisc.animation.Animator;

/**
 * A framework in which to initialize a robot task. You can copy this file for your own
 * work, or simply edit it.
 * 
 * @author Cay Horstmann (with edits by Joe Bergin)
 * 
 */
public class KarelProgram extends Program
{
	
	private static final long serialVersionUID = 1L;
	private KarelWorld scene;

	/**
	 * Create a world of interest. Edit this for your own worlds. This is the only method
	 * you should need to edit. Create the world object and assign it to the scene variable.
	 * Make sure you send it the setTheStage message. 
	 */
	public KarelProgram()
	{
		// Create an object here from a class that extends KarelWorld.
//		scene = new MazeWorld();
//		scene = new StairWorld();
		scene = new PhilosopherWorld();
//		scene = new TestWorld();

		// leave the next statement here. It sets up your world. 
		scene.setTheStage();
		//scene.showScene(0, 0, 12, 12);
	}

	/**
	 * Tell the program which scene to "run"
	 * 
	 * @see edu.cmu.cs.dennisc.program.Program#initialize()
	 */
	@Override
	protected void initialize()
	{
		setScene(scene);
	}

	/**
	 * Execute the simulation defined in the scene
	 * 
	 * @see edu.cmu.cs.dennisc.program.Program#run()
	 */
	@Override
	protected void run()
	{
		scene.run();
	}

	public static void main(String[] args)
	{
		KarelProgram theProgram = new KarelProgram();
		theProgram.showInJFrame(args, true);
	}
}
