package alice.kareluser;

import org.alice.apis.moveandturn.Color;
import org.alice.apis.moveandturn.MoveDirection;
import org.alice.apis.moveandturn.SymmetricPerspectiveCamera;
import org.alice.apis.moveandturn.TurnDirection;
import org.alice.apis.moveandturn.gallery.environments.grounds.GrassyGround;
import org.alice.apis.moveandturn.gallery.environments.grounds.SeaSurface;

import alice.kareltherobot.Direction;
import alice.kareltherobot.KarelWorld;

/**
 * @author Cay Horstmann (edits by Joe Bergin)
 * 
 */
public class MazeWorld extends KarelWorld
{
	public MazeWorld()
	{
		super(new GrassyGround());
	}
	
	private WallFollower carol;

	// This method sets up the maze. Don't look inside.
	/**
	 * Set up the maze situation
	 */
	public void setTheStage()
	{
		carol = new WallFollower(5, 1, Direction.WEST, 1, Color.YELLOW);
		addRobot(carol);
		SymmetricPerspectiveCamera camera = getCamera();
		this.moveCameraTo(1, 1, 3);
//		camera.turn(TurnDirection.BACKWARD, 30.0/360); // back to horizontal
//		camera.move(MoveDirection.FORWARD, 10); 
//		camera.move(MoveDirection.LEFT, 1);
		carol.setTracing(false);
		addDecorations();
		camera.pointAt(carol);
		cameraFollow(carol);
//		 camera.setVehicle(carol);
		// directional experiments
		// camera.move(MoveDirection.RIGHT, 3); // fourth avenue
		// (before a move).
		// camera.turn(TurnDirection.LEFT, .5); // 180 degrees
		// camera.turn(TurnDirection.FORWARD, 30.0/360); // down 30
		readWorld("worlds", "amazin.kwld");
	}

	/**
	 * Execute the maze task
	 * 
	 * @see KarelWorld#run()
	 */
	public void run()
	{
		carol.followWallRight();
		carol.pickBeeper();
		// task ends here, but the rest is for testing and demonstration
		carol.move();

		carol.move();
		carol.putBeeper();
		carol.move();
		carol.putBeeper();
		carol.move();
		carol.putBeeper(); // intentional error.
		carol.move();

	}

}
