package alice.kareluser;

import org.alice.apis.moveandturn.AbstractCamera;
import org.alice.apis.moveandturn.Color;
import org.alice.virtualmachine.DoTogether;
import org.alice.apis.moveandturn.Model;
import org.alice.apis.moveandturn.MoveDirection;
import org.alice.apis.moveandturn.RollDirection;
import org.alice.apis.moveandturn.SymmetricPerspectiveCamera;
import org.alice.apis.moveandturn.TurnDirection;
import org.alice.apis.moveandturn.gallery.environments.grounds.GrassyGround;
import org.alice.apis.moveandturn.gallery.environments.grounds.SandyGround;

import alice.kareltherobot.Direction;
import alice.kareltherobot.KarelWorld;

/**
 * A simple world in which four philosophers will think and eat together.
 * 
 * @author Joseph Bergin
 * 
 */
public class PhilosopherWorld extends KarelWorld
{

	public PhilosopherWorld()
	{
		super(new GrassyGround());
	}

	private Philosopher plato;
	private Philosopher aristotle;
	private Philosopher kant;
	private Philosopher descartes;

	/**
	 * Execute the Think and Eat task of the four philosophers Run four philosophers
	 * together - competing for the forks.
	 */
	@Override
	public void run()
	{
		DoTogether.invokeAndWait(plato, aristotle, kant, descartes);
	}

	/**
	 * Set up the philosopher situation Add four philosophers to the world and the "forks"
	 * they will use.
	 */
	@Override
	public void setTheStage()
	{
		cameraStayFocusedOn(3,3);
		readWorld("worlds", "philosopher.kwld"); // beeper forks
		plato = new Philosopher(2, 3, Direction.NORTH, 0, Color.RED);
		addRobot(plato);
		aristotle = new Philosopher(3, 2, Direction.EAST, 0, Color.GREEN);
		addRobot(aristotle);
		kant = new Philosopher(4, 3, Direction.SOUTH, 0, Color.BLUE);
		addRobot(kant);
		descartes = new Philosopher(3, 4, Direction.WEST, 0, Color.YELLOW);
		addRobot(descartes);
	}

}
